/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.test;

import javax.management.MBeanServerConnection;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Derived implementation of JBossTestCase for cluster testing.
 *
 * @author <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @author Scott.Stark@jboss.org
 * @version $Revision: 109787 $
 * @see org.jboss.test.JBossTestCase
 */
public class JBossClusteredTestCase extends JBossTestCase
{
   JBossTestClusteredServices clusterServices;
   
   // Static --------------------------------------------------------
   
   /**
    * Overriden to return JBossTestServices as the test delegate.
    */
   public static AbstractTestDelegate getDelegate(Class clazz) throws Exception
   {
      AbstractTestDelegate delegate = new JBossTestClusteredServices(clazz);
      return delegate;
   }

   public JBossClusteredTestCase(String name)
   {
      super(name);
   }
   
   @Override
   protected void setUp() throws Exception
   {
      super.setUp();
      clusterServices = (JBossTestClusteredServices) delegate;
   }
   
   // Public --------------------------------------------------------
   
   

   public void testServerFound() throws Exception
   {
      if (deploymentException != null)
         throw deploymentException;
      assertTrue("Server was not found", getServers() != null);
   }


   public MBeanServerConnection[] getAdaptors() throws Exception
   {
      return clusterServices.getAdaptors();
   }

   public String[] getServers() throws Exception
   {
      return clusterServices.getServers();
   }

   /**
    * Get the JBoss servers as above, but in a form suitable for 
    * embedding in URLs - IPv6 literals will be enclosed in square 
    * brackets (see RFC 2732). For JBAS-8540.
    */
   public String[] getServersForURL() throws Exception 
   {
      return clusterServices.getServersForURL();
   }
   
   public String[] getNamingURLs() throws Exception
   {
      return clusterServices.getNamingURLs();
   }
   public String[] getHANamingURLs() throws Exception
   {
      return clusterServices.getHANamingURLs();
   }
   public String[] getHttpURLs() throws Exception
   {
      return clusterServices.getHttpURLs();
   }

   protected void deploy(MBeanServerConnection server, String name) throws Exception
   {
      clusterServices.deploy(server, name);
   }

   protected void redeploy(MBeanServerConnection server, String name) throws Exception
   {
      clusterServices.redeploy(server, name);
   }

   protected void undeploy(MBeanServerConnection server, String name) throws Exception
   {
      clusterServices.undeploy(server, name);
   }

   public static Test getDeploySetup(final Test test, final String jarNames)
      throws Exception
   {
      return new JBossTestClusteredSetup(test, jarNames);
   }

   public static Test getDeploySetup(final Class clazz, final String jarNames)
      throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(clazz));
      return getDeploySetup(suite, jarNames);
   }

   /**
    * anil
    */
   public void setServerNames(String[] snames) throws Exception
   {
      ((JBossTestClusteredServices) delegate).setServerNames(snames);
   }

   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}
