/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.model.installer.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.jboss.tools.rsp.eclipse.core.runtime.CoreException;
import org.jboss.tools.rsp.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.rsp.eclipse.core.runtime.IStatus;
import org.jboss.tools.rsp.eclipse.core.runtime.Status;
import org.jboss.tools.rsp.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.rsp.foundation.core.tasks.TaskModel;
import org.jboss.tools.rsp.runtime.core.model.DownloadRuntime;
import org.jboss.tools.rsp.runtime.core.model.IDownloadRuntimesModel;
import org.jboss.tools.rsp.runtime.core.model.IRuntimeInstaller;
import org.jboss.tools.rsp.runtime.core.model.installer.internal.DownloadRuntimeOperationUtilFactory;
import org.jboss.tools.rsp.runtime.core.util.internal.DownloadRuntimeOperationUtility;

public class BinaryInstaller
implements IRuntimeInstaller {
    private IDownloadRuntimesModel downloadRuntimesModel;

    public BinaryInstaller(IDownloadRuntimesModel downloadRuntimesModel) {
        this.downloadRuntimesModel = downloadRuntimesModel;
    }

    @Override
    public IStatus installRuntime(DownloadRuntime downloadRuntime, String unzipDirectory, String downloadDirectory, boolean deleteOnExit, TaskModel taskModel, IProgressMonitor monitor) {
        String user = (String)taskModel.getObject("dl.runtime.username");
        String pass = (String)taskModel.getObject("dl.runtime.password");
        monitor.beginTask("Install Runtime '" + downloadRuntime.getName() + "' ...", 100);
        monitor.worked(1);
        try {
            DownloadRuntimeOperationUtility opUtil = DownloadRuntimeOperationUtilFactory.createDownloadRuntimeOperationUtility(taskModel, this.downloadRuntimesModel);
            File f = opUtil.download(unzipDirectory, downloadDirectory, this.getDownloadUrl(downloadRuntime, taskModel), deleteOnExit, user, pass, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            File dest = new File(unzipDirectory, f.getName());
            boolean renamed = f.renameTo(dest);
            if (!renamed) {
                this.copy(f, dest);
            }
            if (!dest.setExecutable(true)) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", "Can't set executable bit to " + dest.getAbsolutePath()));
            }
            taskModel.putObject("dl.runtime.unzipped.home.dir", (Object)unzipDirectory);
            taskModel.putObject("dl.runtime.unzipped.home.dir.bin", (Object)dest.getAbsolutePath());
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return Status.OK_STATUS;
    }

    private void copy(File f, File dest) throws CoreException {
        try {
            Files.copy(f.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.rsp.runtime.core", ioe.getMessage(), (Throwable)ioe));
        }
    }

    private String getDownloadUrl(DownloadRuntime downloadRuntime, TaskModel taskModel) {
        if (downloadRuntime != null) {
            String dlUrl = downloadRuntime.getUrl();
            if (dlUrl == null) {
                return (String)taskModel.getObject("dl.runtime.url");
            }
            return dlUrl;
        }
        return null;
    }
}

