/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.runtime.core.util;

import java.util.HashMap;
import java.util.Map;

public class DownloadRuntimeSessionCache {
    private static DownloadRuntimeSessionCache instance = new DownloadRuntimeSessionCache();
    private Map<Long, DownloadManagerSessionState> map = new HashMap<Long, DownloadManagerSessionState>();

    public static DownloadRuntimeSessionCache getDefault() {
        return instance;
    }

    public DownloadManagerSessionState getState(long requestId) {
        return this.map.get(requestId);
    }

    public void updateRequestState(long requestId, int workflowStep, Map<String, Object> data) {
        DownloadManagerSessionState existing = this.map.computeIfAbsent(requestId, key -> new DownloadManagerSessionState());
        existing.setWorkflowStep(workflowStep);
        existing.getData().putAll(data);
    }

    public static class DownloadManagerSessionState {
        private int workflowStep;
        private Map<String, Object> data;

        public DownloadManagerSessionState() {
            this(new HashMap<String, Object>());
        }

        public DownloadManagerSessionState(Map<String, Object> data) {
            this.data = data;
        }

        public int getWorkflowStep() {
            return this.workflowStep;
        }

        public void setWorkflowStep(int workflowStep) {
            this.workflowStep = workflowStep;
        }

        public Map<String, Object> getData() {
            return this.data;
        }
    }
}

