/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.logging.internal;

import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SLF4JLogReader
implements LogListener {
    private static final Logger LOG = LoggerFactory.getLogger(SLF4JLogReader.class);

    public void logged(LogEntry entry) {
        LogLevel level = entry.getLogLevel();
        switch (level) {
            case DEBUG: {
                SLF4JLogReader.debug(entry);
                break;
            }
            case ERROR: {
                SLF4JLogReader.error(entry);
                break;
            }
            case INFO: {
                SLF4JLogReader.info(entry);
                break;
            }
            case WARN: {
                SLF4JLogReader.warn(entry);
                break;
            }
            default: {
                SLF4JLogReader.warn(entry);
            }
        }
    }

    private static void warn(LogEntry entry) {
        String name = entry.getBundle().getSymbolicName();
        String message = entry.getMessage();
        Throwable ex = entry.getException();
        if (ex != null) {
            LOG.warn("[{}]: {}: ", new Object[]{name, message, ex});
        } else {
            LOG.warn("[{}]: {}", (Object)name, (Object)message);
        }
    }

    private static void info(LogEntry entry) {
        String name = entry.getBundle().getSymbolicName();
        String message = entry.getMessage();
        Throwable ex = entry.getException();
        if (ex != null) {
            LOG.info("[{}]: {}: ", new Object[]{name, message, ex});
        } else {
            LOG.info("[{}]: {}", (Object)name, (Object)message);
        }
    }

    private static void error(LogEntry entry) {
        String name = entry.getBundle().getSymbolicName();
        String message = entry.getMessage();
        Throwable ex = entry.getException();
        if (ex != null) {
            LOG.error("[{}]: {}: ", new Object[]{name, message, ex});
        } else {
            LOG.error("[{}]: {}", (Object)name, (Object)message);
        }
    }

    private static void debug(LogEntry entry) {
        String name = entry.getBundle().getSymbolicName();
        String message = entry.getMessage();
        Throwable ex = entry.getException();
        if (ex != null) {
            LOG.debug("[{}]: {}: ", new Object[]{name, message, ex});
        } else {
            LOG.debug("[{}]: {}", (Object)name, (Object)message);
        }
    }
}

