/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.secure.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import org.jboss.tools.rsp.secure.crypto.CryptoException;
import org.jboss.tools.rsp.secure.crypto.CryptoUtils;
import org.jboss.tools.rsp.secure.crypto.NotInitializedCryptoException;
import org.jboss.tools.rsp.secure.model.ISecureStorage;

public class RSPSecureStorage
implements ISecureStorage {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES";
    private static final String COMMENT = "rsp secure storage";
    private static final String HASH_COMMENT = "#rsp secure storage";
    private File backingFile;
    private byte[] key;
    private Properties secretData;
    private CryptoUtils util;

    public RSPSecureStorage(File file, byte[] key) {
        this(file, key, "AES", "AES");
    }

    public RSPSecureStorage(File file, byte[] key, String algo, String transform) {
        this.backingFile = file;
        this.util = new CryptoUtils(algo, transform);
        this.key = this.util.keyTo16(key);
    }

    public void setKey(byte[] key) {
        this.key = key;
        this.secretData = null;
    }

    @Override
    public void load() throws CryptoException {
        Properties tmp = new Properties();
        if (this.backingFile != null && this.backingFile.exists()) {
            try {
                byte[] encrypted = this.util.getBytesFromFile(this.backingFile);
                byte[] decrypted = this.util.decrypt(this.key, encrypted);
                byte[] magicBytes = HASH_COMMENT.getBytes();
                if (!this.startsWith(decrypted, magicBytes)) {
                    throw new CryptoException("Invalid key", null);
                }
                tmp.load(new ByteArrayInputStream(decrypted));
                Arrays.fill(decrypted, (byte)0);
                this.secretData = tmp;
            }
            catch (IOException | CryptoException e) {
                throw new CryptoException("Unable to decrypt secure storage", e);
            }
        } else if (this.backingFile == null || !this.backingFile.exists()) {
            this.secretData = tmp;
        }
    }

    private boolean startsWith(byte[] all, byte[] magic) {
        int i = 0;
        while (i < magic.length) {
            if (i >= all.length) {
                return false;
            }
            if (all[i] != magic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInitialized() {
        return this.secretData != null;
    }

    @Override
    public void save() throws CryptoException {
        try {
            if (this.backingFile != null && this.isInitialized()) {
                this.backingFile.getParentFile().mkdirs();
                StringWriter sw = new StringWriter();
                this.secretData.store(sw, COMMENT);
                byte[] raw = sw.toString().getBytes(StandardCharsets.UTF_8);
                byte[] encrypted = this.util.encrypt(this.key, raw);
                this.util.writeBytesToFile(this.backingFile, encrypted);
            } else if (!this.isInitialized()) {
                throw new NotInitializedCryptoException("Secure storage not initialized", null);
            }
        }
        catch (IOException ioe) {
            throw new CryptoException("Secure storage not initialized", ioe);
        }
    }

    @Override
    public boolean propertyExists(String nodePath, String propertyName) throws NotInitializedCryptoException {
        if (!this.isInitialized()) {
            throw new NotInitializedCryptoException("Secure storage not initialized", null);
        }
        return ((SecureNode)this.getNode(nodePath)).propertyExists(propertyName);
    }

    @Override
    public ISecureStorage.ISecureNode getNode(String nodePath) throws NotInitializedCryptoException {
        if (!this.isInitialized()) {
            throw new NotInitializedCryptoException("Secure storage not initialized", null);
        }
        return new SecureNode(nodePath);
    }

    public class SecureNode
    implements ISecureStorage.ISecureNode {
        private String path;

        public SecureNode(String path) {
            this.path = path;
        }

        @Override
        public SecureNode getChildNode(String segment) {
            return new SecureNode(this.append(segment));
        }

        private String append(String segment) {
            String toCheck = this.path;
            if (!this.path.endsWith("/")) {
                toCheck = String.valueOf(toCheck) + "/";
            }
            toCheck = String.valueOf(toCheck) + segment;
            return toCheck;
        }

        public boolean propertyExists(String property) {
            return RSPSecureStorage.this.secretData.containsKey(this.append(property));
        }

        @Override
        public String getStringProperty(String prop, String defaultValue) {
            String ret = RSPSecureStorage.this.secretData.getProperty(this.append(prop));
            return ret == null ? defaultValue : ret;
        }

        @Override
        public void setStringProperty(String prop, String val) {
            RSPSecureStorage.this.secretData.setProperty(this.append(prop), val);
            try {
                RSPSecureStorage.this.save();
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
        }

        @Override
        public int getIntegerProperty(String prop, int defaultValue) {
            String asString = this.getStringProperty(prop, null);
            if (asString == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(asString);
            }
            catch (NumberFormatException nfe) {
                return defaultValue;
            }
        }

        @Override
        public void setIntegerProperty(String prop, int val) {
            RSPSecureStorage.this.secretData.setProperty(this.append(prop), Integer.toString(val));
        }

        @Override
        public boolean getBooleanProperty(String prop, boolean defaultValue) {
            String asString = this.getStringProperty(prop, null);
            if (asString == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(asString);
        }

        @Override
        public void setBooleanProperty(String prop, boolean val) {
            RSPSecureStorage.this.secretData.setProperty(this.append(prop), Boolean.toString(val));
        }
    }
}

