/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.api.dao.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.rsp.api.dao.Attribute;
import org.jboss.tools.rsp.api.dao.Attributes;

public class CreateServerAttributesUtility {
    private Map<String, Attribute> attrs;

    public CreateServerAttributesUtility() {
        this.attrs = new LinkedHashMap<String, Attribute>();
    }

    public CreateServerAttributesUtility(Attributes original) {
        this.attrs = new LinkedHashMap<String, Attribute>(original.getAttributes());
    }

    public Set<String> listAttributes() {
        return this.attrs.keySet();
    }

    public String getAttributeType(String key) {
        Attribute a = this.attrs.get(key);
        if (a != null) {
            return a.getType();
        }
        return null;
    }

    public String getAttributeDescription(String key) {
        Attribute a = this.attrs.get(key);
        if (a != null) {
            return a.getDescription();
        }
        return null;
    }

    public boolean isAttributeSecret(String key) {
        Attribute a = this.attrs.get(key);
        if (a != null) {
            return a.isSecret();
        }
        return false;
    }

    public Object getAttributeDefaultValue(String key) {
        Attribute a = this.attrs.get(key);
        if (a != null) {
            return a.getDefaultVal();
        }
        return null;
    }

    public void addAttribute(String key, String type, String d, Object defaultVal) {
        Attribute a = new Attribute(type, d, defaultVal);
        this.attrs.put(key, a);
    }

    public void addAttribute(String key, String type, String d, Object defaultVal, boolean secret) {
        Attribute a = new Attribute(type, d, defaultVal, secret);
        this.attrs.put(key, a);
    }

    public void removeAttribute(String key) {
        this.attrs.remove(key);
    }

    public Attributes toPojo() {
        return new Attributes(this.attrs);
    }
}

