/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.transaction.UserTransaction;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.PlugableValidator;
import org.jboss.weld.util.reflection.Formats;

class WeldEjbValidator
implements PlugableValidator {
    WeldEjbValidator() {
    }

    public void validateInjectionPointForDefinitionErrors(InjectionPoint ij, Bean<?> bean, BeanManagerImpl beanManager) {
        if (bean instanceof SessionBean) {
            SessionBean sessionBean = (SessionBean)bean;
            if (UserTransaction.class.equals((Object)ij.getType()) && (ij.getQualifiers().isEmpty() || ij.getQualifiers().contains(DefaultLiteral.INSTANCE)) && this.hasContainerManagedTransactions(sessionBean)) {
                throw ValidatorLogger.LOG.userTransactionInjectionIntoBeanWithContainerManagedTransactions((Object)ij, (Object)Formats.formatAsStackTraceElement((InjectionPoint)ij));
            }
        }
    }

    private boolean hasContainerManagedTransactions(SessionBean<?> bean) {
        TransactionManagement transactionManagementAnnotation = (TransactionManagement)bean.getAnnotated().getAnnotation(TransactionManagement.class);
        if (transactionManagementAnnotation == null) {
            return true;
        }
        return transactionManagementAnnotation.value() == TransactionManagementType.CONTAINER;
    }
}

