/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.interceptor.InvocationContext;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.event.ContextEvent;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;

public abstract class AbstractEJBRequestScopeActivationInterceptor
implements Serializable {
    private static final long serialVersionUID = 7327757031821596782L;
    private final LazyValueHolder<FastEvent<Object>> requestInitializedEvent = new LazyValueHolder.Serializable<FastEvent<Object>>(){
        private static final long serialVersionUID = 1L;

        protected FastEvent<Object> computeValue() {
            return FastEvent.of(Object.class, (BeanManagerImpl)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager(), (ObserverNotifier)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager().getGlobalLenientObserverNotifier(), (Annotation[])new Annotation[]{Initialized.Literal.REQUEST});
        }
    };
    private final LazyValueHolder<FastEvent<Object>> requestBeforeDestroyedEvent = new LazyValueHolder.Serializable<FastEvent<Object>>(){
        private static final long serialVersionUID = 1L;

        protected FastEvent<Object> computeValue() {
            return FastEvent.of(Object.class, (BeanManagerImpl)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager(), (ObserverNotifier)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager().getGlobalLenientObserverNotifier(), (Annotation[])new Annotation[]{BeforeDestroyed.Literal.REQUEST});
        }
    };
    private final LazyValueHolder<FastEvent<Object>> requestDestroyedEvent = new LazyValueHolder.Serializable<FastEvent<Object>>(){
        private static final long serialVersionUID = 1L;

        protected FastEvent<Object> computeValue() {
            return FastEvent.of(Object.class, (BeanManagerImpl)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager(), (ObserverNotifier)AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager().getGlobalLenientObserverNotifier(), (Annotation[])new Annotation[]{Destroyed.Literal.REQUEST});
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.isRequestContextActive()) {
            return invocation.proceed();
        }
        EjbRequestContext requestContext = this.getEjbRequestContext();
        try {
            Object object;
            requestContext.associate((Object)invocation);
            requestContext.activate();
            try {
                ((FastEvent)this.requestInitializedEvent.get()).fire(ContextEvent.REQUEST_INITIALIZED_EJB);
                object = invocation.proceed();
            }
            catch (Throwable throwable) {
                ((FastEvent)this.requestBeforeDestroyedEvent.get()).fire(ContextEvent.REQUEST_BEFORE_DESTROYED_EJB);
                requestContext.invalidate();
                requestContext.deactivate();
                throw throwable;
            }
            ((FastEvent)this.requestBeforeDestroyedEvent.get()).fire(ContextEvent.REQUEST_BEFORE_DESTROYED_EJB);
            requestContext.invalidate();
            requestContext.deactivate();
            return object;
        }
        finally {
            requestContext.dissociate((Object)invocation);
            ((FastEvent)this.requestDestroyedEvent.get()).fire(ContextEvent.REQUEST_DESTROYED_EJB);
        }
    }

    protected boolean isRequestContextActive() {
        return this.getBeanManager().isContextActive(RequestScoped.class);
    }

    protected EjbRequestContext getEjbRequestContext() {
        return (EjbRequestContext)this.getBeanManager().instance().select(EjbRequestContext.class, new Annotation[0]).get();
    }

    protected abstract BeanManagerImpl getBeanManager();
}

