/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.ejb.EnterpriseBeanInstance;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.SessionBeanAwareInjectionPointBean;
import org.jboss.weld.ejb.SessionBeanProxyInstantiator;
import org.jboss.weld.ejb.SessionBeans;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.reflection.Formats;

class SessionBeanImpl<T>
extends AbstractClassBean<T>
implements SessionBean<T> {
    private final InternalEjbDescriptor<T> ejbDescriptor;
    private Instantiator<T> proxyInstantiator;

    public static <T> SessionBean<T> of(BeanAttributes<T> attributes, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl beanManager, EnhancedAnnotatedType<T> type) {
        return new SessionBeanImpl<T>(attributes, type, ejbDescriptor, (BeanIdentifier)new StringBeanIdentifier(SessionBeans.createIdentifier(type, ejbDescriptor)), beanManager);
    }

    SessionBeanImpl(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, InternalEjbDescriptor<T> ejbDescriptor, BeanIdentifier identifier, BeanManagerImpl manager) {
        super(attributes, type, identifier, manager);
        this.ejbDescriptor = ejbDescriptor;
        this.setProducer((InjectionTarget)this.beanManager.getLocalInjectionTargetFactory(type).createInjectionTarget(type, (Bean)this, false));
    }

    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkEJBTypeAllowed();
        this.checkConflictingRoles();
        this.checkObserverMethods();
        this.checkScopeAllowed();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw BeanLogger.LOG.ejbCannotBeInterceptor((Object)this.getType());
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw BeanLogger.LOG.ejbCannotBeDecorator((Object)this.getType());
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw BeanLogger.LOG.scopeNotAllowedOnStatelessSessionBean((Object)this.getScope(), (Object)this.getType());
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw BeanLogger.LOG.scopeNotAllowedOnSingletonBean((Object)this.getScope(), (Object)this.getType());
        }
    }

    protected void specialize() {
        Set specializedBeans = this.getSpecializedBeans();
        if (specializedBeans.isEmpty()) {
            throw BeanLogger.LOG.specializingEnterpriseBeanMustExtendAnEnterpriseBean((Object)this);
        }
        for (AbstractBean specializedBean : specializedBeans) {
            if (specializedBean instanceof SessionBean) continue;
            throw BeanLogger.LOG.specializingEnterpriseBeanMustExtendAnEnterpriseBean((Object)this);
        }
    }

    public T create(CreationalContext<T> creationalContext) {
        return (T)this.proxyInstantiator.newInstance(creationalContext, this.beanManager);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        super.destroy(instance, creationalContext);
        if (instance == null) {
            throw BeanLogger.LOG.cannotDestroyNullBean((Object)this);
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw BeanLogger.LOG.cannotDestroyEnterpriseBeanNotCreated(instance);
        }
        EnterpriseBeanInstance enterpriseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpriseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw BeanLogger.LOG.messageDrivenBeansCannotBeManaged((Object)this);
        }
    }

    protected void checkType() {
        if (!this.isDependent() && this.getEnhancedAnnotated().isGeneric()) {
            throw BeanLogger.LOG.genericSessionBeanMustBeDependent((Object)this);
        }
        boolean passivating = ((MetaAnnotationStore)this.beanManager.getServices().get(MetaAnnotationStore.class)).getScopeModel(this.getScope()).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw BeanLogger.LOG.passivatingBeanNeedsSerializableImpl((Object)this);
        }
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    protected void checkObserverMethods() {
        Collection observerMethods = BeanMethods.getObserverMethods((EnhancedAnnotatedType)this.getEnhancedAnnotated());
        Collection asyncObserverMethods = BeanMethods.getAsyncObserverMethods((EnhancedAnnotatedType)this.getEnhancedAnnotated());
        this.checkObserverMethods(observerMethods);
        this.checkObserverMethods(asyncObserverMethods);
    }

    private void checkObserverMethods(Collection<EnhancedAnnotatedMethod<?, ? super T>> observerMethods) {
        if (!observerMethods.isEmpty()) {
            Set<MethodSignature> businessMethodSignatures = this.getLocalBusinessMethodSignatures();
            Set<MethodSignature> remoteBusinessMethodSignatures = this.getRemoteBusinessMethodSignatures();
            for (EnhancedAnnotatedMethod<?, T> enhancedAnnotatedMethod : observerMethods) {
                boolean isLocalBusinessMethod = !remoteBusinessMethodSignatures.contains(enhancedAnnotatedMethod.getSignature()) && businessMethodSignatures.contains(enhancedAnnotatedMethod.getSignature());
                if (isLocalBusinessMethod || enhancedAnnotatedMethod.isStatic()) continue;
                throw BeanLogger.LOG.observerMethodMustBeStaticOrBusiness(enhancedAnnotatedMethod, (Object)Formats.formatAsStackTraceElement((Member)enhancedAnnotatedMethod.getJavaMember()));
            }
        }
    }

    public Set<MethodSignature> getLocalBusinessMethodSignatures() {
        HashSet<MethodSignatureImpl> businessMethodSignatures = new HashSet<MethodSignatureImpl>();
        for (BusinessInterfaceDescriptor businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        return Collections.unmodifiableSet(businessMethodSignatures);
    }

    public Set<MethodSignature> getRemoteBusinessMethodSignatures() {
        HashSet<MethodSignatureImpl> businessMethodSignatures = new HashSet<MethodSignatureImpl>();
        for (BusinessInterfaceDescriptor businessInterfaceDescriptor : this.ejbDescriptor.getRemoteBusinessInterfaces()) {
            for (Method m : businessInterfaceDescriptor.getInterface().getMethods()) {
                businessMethodSignatures.add(new MethodSignatureImpl(m));
            }
        }
        return Collections.unmodifiableSet(businessMethodSignatures);
    }

    public SessionObjectReference createReference() {
        try {
            SessionBeanAwareInjectionPointBean.registerContextualInstance(this.getEjbDescriptor());
            SessionObjectReference sessionObjectReference = ((EjbServices)this.beanManager.getServices().get(EjbServices.class)).resolveEjb(this.getEjbDescriptor().delegate());
            return sessionObjectReference;
        }
        finally {
            SessionBeanAwareInjectionPointBean.unregisterContextualInstance(this.getEjbDescriptor());
        }
    }

    protected boolean isInterceptionCandidate() {
        return true;
    }

    public String toString() {
        return "Session bean [" + this.getBeanClass() + " with qualifiers [" + Formats.formatAnnotations((Iterable)this.getQualifiers()) + "]; local interfaces are [" + Formats.formatBusinessInterfaceDescriptors((Iterable)this.getEjbDescriptor().getLocalBusinessInterfaces()) + "]";
    }

    public boolean isProxyable() {
        return true;
    }

    public boolean isPassivationCapableBean() {
        return this.ejbDescriptor.isPassivationCapable();
    }

    public boolean isPassivationCapableDependency() {
        return this.ejbDescriptor.isStateful() && this.isPassivationCapableBean() || this.ejbDescriptor.isSingleton() || this.ejbDescriptor.isStateless();
    }

    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.proxyInstantiator = new SessionBeanProxyInstantiator(this.enhancedAnnotatedItem, this);
        this.registerInterceptors();
    }

    protected void registerInterceptors() {
        InterceptionModel model = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getAnnotated());
        if (model != null) {
            ((EjbServices)this.getBeanManager().getServices().get(EjbServices.class)).registerInterceptors(this.getEjbDescriptor().delegate(), (InterceptorBindings)new InterceptorBindingsAdapter(model));
        }
    }
}

