/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import org.jboss.weld.bean.SyntheticClassBean;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class SyntheticDecorator<T>
extends SyntheticClassBean<T>
implements Decorator<T> {
    private final InjectionPoint delegate = this.identifyDelegateInjectionPoint(this.getInjectionPoints());
    private final Set<Type> decoratedTypes;

    public SyntheticDecorator(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
        super(attributes, beanClass, factory, manager);
        this.decoratedTypes = ImmutableSet.copyOf(this.getDecoratedTypes(attributes.getTypes()));
    }

    protected InjectionPoint identifyDelegateInjectionPoint(Set<InjectionPoint> injectionPoints) {
        InjectionPoint delegate = null;
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (!injectionPoint.isDelegate()) continue;
            if (delegate != null) {
                throw BeanLogger.LOG.tooManyDelegatesForDecorator(this.getBeanClass());
            }
            delegate = injectionPoint;
        }
        if (delegate == null) {
            throw BeanLogger.LOG.noDelegateForDecorator(this.getBeanClass());
        }
        return delegate;
    }

    protected Set<Type> getDecoratedTypes(Set<Type> types) {
        HashSet<Type> decoratedTypes = new HashSet<Type>();
        for (Type type : types) {
            Class rawType = Reflections.getRawType(type);
            if (!rawType.isInterface() || Serializable.class.equals(rawType)) continue;
            decoratedTypes.add(type);
        }
        return decoratedTypes;
    }

    @Override
    public Type getDelegateType() {
        return this.delegate.getType();
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegate.getQualifiers();
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }
}

