/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;

public class InterceptorResolvableBuilder
extends ResolvableBuilder {
    private InterceptionType interceptionType;

    public InterceptorResolvableBuilder(BeanManagerImpl manager) {
        super(manager);
    }

    public InterceptorResolvableBuilder(Type type, BeanManagerImpl manager) {
        super(type, manager);
    }

    @Override
    protected void checkQualifier(Annotation qualifier, QualifierInstance qualifierInstance, Class<? extends Annotation> annotationType) {
        if (!this.getMetaAnnotationStore().getInterceptorBindingModel(annotationType).isValid()) {
            throw BeanManagerLogger.LOG.interceptorResolutionWithNonbindingType(qualifier);
        }
        if (this.qualifierInstances.contains(qualifierInstance)) {
            throw BeanManagerLogger.LOG.duplicateInterceptorBinding(this.qualifierInstances);
        }
    }

    public InterceptorResolvableBuilder setInterceptionType(InterceptionType interceptionType) {
        this.interceptionType = interceptionType;
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifier(Annotation qualifier) {
        super.addQualifier(qualifier);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Annotation[] qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addQualifiers(Collection<Annotation> qualifiers) {
        super.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addType(Type type) {
        super.addType(type);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder addTypes(Set<Type> types) {
        super.addTypes(types);
        return this;
    }

    @Override
    public InterceptorResolvableBuilder setDeclaringBean(Bean<?> declaringBean) {
        super.setDeclaringBean(declaringBean);
        return this;
    }

    @Override
    public InterceptorResolvable create() {
        if (this.qualifierInstances.isEmpty()) {
            throw BeanManagerLogger.LOG.interceptorBindingsEmpty();
        }
        return new InterceptorResolvableImpl(this.rawType, this.types, this.declaringBean, this.interceptionType, this.qualifierInstances);
    }

    private static class InterceptorResolvableImpl
    extends ResolvableBuilder.ResolvableImpl
    implements InterceptorResolvable {
        private final InterceptionType interceptionType;

        private InterceptorResolvableImpl(Class<?> rawType, Set<Type> typeClosure, Bean<?> declaringBean, InterceptionType interceptionType, Set<QualifierInstance> instances) {
            super(rawType, typeClosure, declaringBean, instances, false);
            this.interceptionType = interceptionType;
        }

        @Override
        public InterceptionType getInterceptionType() {
            return this.interceptionType;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.getInterceptionType().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Resolvable) {
                Resolvable r = (Resolvable)o;
                return super.equals(r) && r instanceof InterceptorResolvable && this.getInterceptionType().equals((Object)((InterceptorResolvable)r).getInterceptionType());
            }
            return false;
        }
    }
}

