/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.jboss.weld.util.collections.Iterators;

public final class Iterables {
    private Iterables() {
    }

    public static <T> boolean addAll(Collection<T> target, Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return target.addAll((Collection)iterable);
        }
        return Iterators.addAll(target, iterable.iterator());
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        return () -> Iterators.concat(Iterables.iterators(iterables));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        return Iterables.concat(Arrays.asList(a, b));
    }

    public static <T> Iterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        return Iterators.transform(iterables.iterator(), Iterable::iterator);
    }

    public static <T, R> Iterable<R> transform(Iterable<T> iterable, Function<? super T, ? extends R> function) {
        return () -> new Iterators.TransformingIterator(iterable.iterator(), function);
    }

    public static <T, R> Iterable<R> flatMap(Iterable<T> iterable, Function<? super T, ? extends Iterable<? extends R>> function) {
        return Iterables.concat(Iterables.transform(iterable, function));
    }
}

