/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import org.jboss.weld.context.AbstractContext;
import org.jboss.weld.context.ManagedContext;

public abstract class AbstractManagedContext
extends AbstractContext
implements ManagedContext {
    private final ThreadLocal<ManagedState> state = new ThreadLocal();

    public AbstractManagedContext(String contextId, boolean multithreaded) {
        super(contextId, multithreaded);
    }

    @Override
    public boolean isActive() {
        ManagedState managedState = this.state.get();
        return managedState != null ? managedState.isActive() : false;
    }

    protected void setActive(boolean active) {
        this.getManagedState().setActive(active);
    }

    @Override
    public void invalidate() {
        this.getManagedState().setValid(false);
    }

    @Override
    public void activate() {
        this.setActive(true);
    }

    public boolean isValid() {
        ManagedState managedState = this.state.get();
        return managedState != null ? managedState.isValid() : false;
    }

    @Override
    public void deactivate() {
        if (!this.isValid()) {
            this.destroy();
        }
        this.state.remove();
    }

    private ManagedState getManagedState() {
        ManagedState managedState = this.state.get();
        if (managedState == null) {
            managedState = new ManagedState();
            this.state.set(managedState);
        }
        return managedState;
    }

    private static class ManagedState {
        private boolean isActive = false;
        private boolean isValid = true;

        private ManagedState() {
        }

        boolean isActive() {
            return this.isActive;
        }

        void setActive(boolean isActive) {
            this.isActive = isActive;
        }

        boolean isValid() {
            return this.isValid;
        }

        void setValid(boolean isValid) {
            this.isValid = isValid;
        }
    }
}

