/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.builder.InterceptorsApiAbstraction;
import org.jboss.weld.interceptor.reader.InterceptorMetadataReader;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Interceptors;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionModelInitializer<T> {
    private final BeanManagerImpl manager;
    private final InterceptorMetadataReader reader;
    private final EnhancedAnnotatedType<T> annotatedType;
    private final Set<Class<? extends Annotation>> stereotypes;
    private final EnhancedAnnotatedConstructor<T> constructor;
    private final InterceptorsApiAbstraction interceptorsApi;
    private final Class<? extends Annotation> timeoutAnnotation;
    private List<EnhancedAnnotatedMethod<?, ?>> businessMethods;
    private final InterceptionModelBuilder builder;
    private boolean hasSerializationOrInvocationInterceptorMethods;

    public static <T> InterceptionModelInitializer<T> of(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, Bean<?> bean) {
        return new InterceptionModelInitializer<T>(manager, annotatedType, Beans.getBeanConstructorStrict(annotatedType), bean);
    }

    public InterceptionModelInitializer(BeanManagerImpl manager, EnhancedAnnotatedType<T> annotatedType, EnhancedAnnotatedConstructor<T> constructor, Bean<?> bean) {
        this.constructor = constructor;
        this.manager = manager;
        this.reader = manager.getInterceptorMetadataReader();
        this.annotatedType = annotatedType;
        this.builder = new InterceptionModelBuilder();
        this.stereotypes = bean == null ? Collections.emptySet() : bean.getStereotypes();
        this.interceptorsApi = manager.getServices().get(InterceptorsApiAbstraction.class);
        this.timeoutAnnotation = manager.getServices().get(EjbSupport.class).getTimeoutAnnotation();
    }

    public void init() {
        this.initTargetClassInterceptors();
        this.businessMethods = Beans.getInterceptableMethods(this.annotatedType);
        this.initEjbInterceptors();
        this.initCdiInterceptors();
        InterceptionModel interceptionModel = this.builder.build();
        if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
            if (this.annotatedType.isFinal()) {
                throw BeanLogger.LOG.finalBeanClassWithInterceptorsNotAllowed(this.annotatedType.getJavaClass());
            }
            if (Reflections.isPrivate(this.constructor.getJavaMember())) {
                throw new DeploymentException(ValidatorLogger.LOG.notProxyablePrivateConstructor(this.annotatedType.getJavaClass().getName(), this.constructor, this.annotatedType.getJavaClass()));
            }
            this.manager.getInterceptorModelRegistry().put((SlimAnnotatedType<?>)this.annotatedType.slim(), interceptionModel);
        }
    }

    private void initTargetClassInterceptors() {
        if (!Beans.isInterceptor(this.annotatedType)) {
            TargetClassInterceptorMetadata interceptorClassMetadata = this.reader.getTargetClassInterceptorMetadata(this.annotatedType);
            this.builder.setTargetClassInterceptorMetadata(interceptorClassMetadata);
            this.hasSerializationOrInvocationInterceptorMethods = interceptorClassMetadata.isEligible(InterceptionType.AROUND_INVOKE) || interceptorClassMetadata.isEligible(InterceptionType.AROUND_TIMEOUT) || interceptorClassMetadata.isEligible(InterceptionType.PRE_PASSIVATE) || interceptorClassMetadata.isEligible(InterceptionType.POST_ACTIVATE);
        } else {
            this.hasSerializationOrInvocationInterceptorMethods = false;
        }
    }

    private void initCdiInterceptors() {
        Multimap<Class<? extends Annotation>, Annotation> classBindingAnnotations = this.getClassInterceptorBindings();
        Set<Annotation> bindings = classBindingAnnotations.uniqueValues();
        this.builder.setClassInterceptorBindings(bindings);
        this.initCdiLifecycleInterceptors(bindings);
        this.initCdiConstructorInterceptors(classBindingAnnotations);
        this.initCdiBusinessMethodInterceptors(classBindingAnnotations);
    }

    private Multimap<Class<? extends Annotation>, Annotation> getClassInterceptorBindings() {
        return Interceptors.mergeBeanInterceptorBindings(this.manager, this.annotatedType, this.stereotypes);
    }

    private void initCdiLifecycleInterceptors(Set<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return;
        }
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE, null, qualifiers);
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE, null, qualifiers);
    }

    private void initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, AnnotatedConstructor<?> constructor, Set<Annotation> annotations) {
        List<Interceptor<?>> resolvedInterceptors = this.manager.resolveInterceptors(interceptionType, annotations);
        if (!resolvedInterceptors.isEmpty()) {
            if (constructor != null) {
                this.builder.interceptGlobal(interceptionType, (Constructor<?>)constructor.getJavaMember(), (Collection<InterceptorClassMetadata<?>>)this.asInterceptorMetadata(resolvedInterceptors), annotations);
            } else {
                this.builder.interceptGlobal(interceptionType, null, this.asInterceptorMetadata(resolvedInterceptors), null);
            }
        }
    }

    private void initCdiBusinessMethodInterceptors(Multimap<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        for (EnhancedAnnotatedMethod<?, ?> method : this.businessMethods) {
            this.initCdiBusinessMethodInterceptor(method, this.getMemberBindingAnnotations(classBindingAnnotations, method.getMetaAnnotations(InterceptorBinding.class)));
        }
    }

    private void initCdiBusinessMethodInterceptor(AnnotatedMethod<?> method, Set<Annotation> methodBindingAnnotations) {
        if (methodBindingAnnotations.size() == 0) {
            return;
        }
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method, methodBindingAnnotations);
        this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method, methodBindingAnnotations);
    }

    private void initInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, AnnotatedMethod<?> method, Set<Annotation> methodBindingAnnotations) {
        List<Interceptor<?>> methodBoundInterceptors = this.manager.resolveInterceptors(interceptionType, methodBindingAnnotations);
        if (methodBoundInterceptors != null && methodBoundInterceptors.size() > 0) {
            if (Reflections.isFinal(method.getJavaMember())) {
                throw BeanLogger.LOG.finalInterceptedBeanMethodNotAllowed(method, methodBoundInterceptors.get(0).getBeanClass().getName());
            }
            Method javaMethod = method.getJavaMember();
            this.builder.interceptMethod(interceptionType, javaMethod, this.asInterceptorMetadata(methodBoundInterceptors), methodBindingAnnotations);
        }
    }

    private void initCdiConstructorInterceptors(Multimap<Class<? extends Annotation>, Annotation> classBindingAnnotations) {
        Set<Annotation> constructorBindings = this.getMemberBindingAnnotations(classBindingAnnotations, this.constructor.getMetaAnnotations(InterceptorBinding.class));
        if (constructorBindings.isEmpty()) {
            return;
        }
        this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT, this.constructor, constructorBindings);
    }

    private Set<Annotation> getMemberBindingAnnotations(Multimap<Class<? extends Annotation>, Annotation> classBindingAnnotations, Set<Annotation> memberAnnotations) {
        Set<Annotation> methodBindingAnnotations = Interceptors.flattenInterceptorBindings(this.manager, Interceptors.filterInterceptorBindings(this.manager, memberAnnotations), true, true);
        return this.mergeMemberInterceptorBindings(classBindingAnnotations, methodBindingAnnotations).uniqueValues();
    }

    private void initEjbInterceptors() {
        this.initClassDeclaredEjbInterceptors();
        this.initConstructorDeclaredEjbInterceptors();
        for (AnnotatedMethod annotatedMethod : this.businessMethods) {
            this.initMethodDeclaredEjbInterceptors(annotatedMethod);
        }
    }

    private void initClassDeclaredEjbInterceptors() {
        Class<?>[] classDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(this.annotatedType);
        boolean excludeClassLevelAroundConstructInterceptors = this.constructor.isAnnotationPresent(ExcludeClassInterceptors.class);
        if (classDeclaredInterceptors != null) {
            for (Class<?> clazz : classDeclaredInterceptors) {
                InterceptorClassMetadata<?> interceptor = this.reader.getPlainInterceptorMetadata(clazz);
                for (javax.enterprise.inject.spi.InterceptionType interceptionType : javax.enterprise.inject.spi.InterceptionType.values()) {
                    if (excludeClassLevelAroundConstructInterceptors && interceptionType.equals((Object)javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT) || !interceptor.isEligible(InterceptionType.valueOf(interceptionType))) continue;
                    this.builder.interceptGlobal(interceptionType, null, Collections.singleton(interceptor), null);
                }
            }
        }
    }

    public void initConstructorDeclaredEjbInterceptors() {
        Class<?>[] constructorDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(this.constructor);
        if (constructorDeclaredInterceptors != null) {
            for (Class<?> clazz : constructorDeclaredInterceptors) {
                this.builder.interceptGlobal(javax.enterprise.inject.spi.InterceptionType.AROUND_CONSTRUCT, null, Collections.singleton(this.reader.getPlainInterceptorMetadata(clazz)), null);
            }
        }
    }

    private void initMethodDeclaredEjbInterceptors(AnnotatedMethod<?> method) {
        Class<?>[] methodDeclaredInterceptors;
        Method javaMethod = method.getJavaMember();
        boolean excludeClassInterceptors = method.isAnnotationPresent(this.interceptorsApi.getExcludeClassInterceptorsAnnotationClass());
        if (excludeClassInterceptors) {
            this.builder.addMethodIgnoringGlobalInterceptors(javaMethod);
        }
        if ((methodDeclaredInterceptors = this.interceptorsApi.extractInterceptorClasses(method)) != null && methodDeclaredInterceptors.length > 0) {
            if (Reflections.isFinal(method.getJavaMember())) {
                throw new DeploymentException(BeanLogger.LOG.finalInterceptedBeanMethodNotAllowed(method, methodDeclaredInterceptors[0].getName()));
            }
            javax.enterprise.inject.spi.InterceptionType interceptionType = this.isTimeoutAnnotationPresentOn(method) ? javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT : javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE;
            this.builder.interceptMethod(interceptionType, javaMethod, this.getMethodDeclaredInterceptorMetadatas(methodDeclaredInterceptors), null);
        }
    }

    private List<InterceptorClassMetadata<?>> getMethodDeclaredInterceptorMetadatas(Class<?>[] methodDeclaredInterceptors) {
        LinkedList list = new LinkedList();
        for (Class<?> clazz : methodDeclaredInterceptors) {
            list.add(this.reader.getPlainInterceptorMetadata(clazz));
        }
        return list;
    }

    private boolean isTimeoutAnnotationPresentOn(AnnotatedMethod<?> method) {
        return this.timeoutAnnotation != null && method.isAnnotationPresent(this.timeoutAnnotation);
    }

    protected Multimap<Class<? extends Annotation>, Annotation> mergeMemberInterceptorBindings(Multimap<Class<? extends Annotation>, Annotation> beanBindings, Set<Annotation> methodBindingAnnotations) {
        SetMultimap<Class<? extends Annotation>, Annotation> mergedBeanBindings = SetMultimap.newSetMultimap(beanBindings);
        SetMultimap<Class, Annotation> methodBindings = SetMultimap.newSetMultimap();
        for (Annotation methodBinding : methodBindingAnnotations) {
            methodBindings.put(methodBinding.annotationType(), methodBinding);
        }
        for (Class key : methodBindings.keySet()) {
            mergedBeanBindings.replaceValues(key, methodBindings.get(key));
        }
        return mergedBeanBindings;
    }

    private List<InterceptorClassMetadata<?>> asInterceptorMetadata(List<Interceptor<?>> interceptors) {
        return interceptors.stream().map(this.reader::getCdiInterceptorMetadata).collect(Collectors.toList());
    }

    public String toString() {
        return "InterceptionModelInitializer for " + this.annotatedType.getJavaClass();
    }
}

