/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public abstract class AbstractNamingScheme
implements NamingScheme {
    private final String delimiter;

    public AbstractNamingScheme(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public boolean accept(String id) {
        String prefix = this.getPrefix();
        return id.startsWith(prefix) && id.startsWith(this.delimiter, prefix.length());
    }

    @Override
    public BeanIdentifier deprefix(String id) {
        return new StringBeanIdentifier(id.substring(this.getPrefix().length() + this.delimiter.length()));
    }

    @Override
    public String prefix(BeanIdentifier id) {
        return this.getPrefix() + this.delimiter + id.asString();
    }

    @Override
    public Collection<String> filterIds(Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> filtered = new ArrayList<String>();
        while (iterator.hasNext()) {
            String id = iterator.next();
            if (!this.accept(id)) continue;
            filtered.add(id);
        }
        return filtered;
    }

    @Override
    public Collection<BeanIdentifier> deprefix(Collection<String> ids) {
        return ids.stream().map(this::deprefix).collect(Collectors.toList());
    }

    @Override
    public Collection<String> prefix(Collection<BeanIdentifier> ids) {
        return ids.stream().map(this::prefix).collect(Collectors.toList());
    }

    protected abstract String getPrefix();

    protected String getDelimiter() {
        return this.delimiter;
    }
}

