/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.config.SystemPropertiesConfiguration;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.XmlLogger;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.jboss.weld.xml.XmlSchema;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXmlParser {
    private static final InputSource[] EMPTY_INPUT_SOURCE_ARRAY = new InputSource[0];
    private Function<URL, BeansXml> URL_TO_BEANS_XML_FUNCTION = this::parse;
    private static Function<BeanDeploymentArchive, BeansXml> BEAN_ARCHIVE_TO_BEANS_XML_FUNCTION = archive -> {
        if (archive == null) {
            return null;
        }
        return archive.getBeansXml();
    };
    private static Function<BeansXml, BeansXml> BEANS_XML_IDENTITY_FUNCTION = beansXml -> beansXml;

    public BeansXml parse(URL beansXml) {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(!SystemPropertiesConfiguration.INSTANCE.isXmlValidationDisabled());
        factory.setNamespaceAware(true);
        if (beansXml == null) {
            throw XmlLogger.LOG.loadError("unknown", null);
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw XmlLogger.LOG.configurationError(e);
        }
        catch (ParserConfigurationException e) {
            throw XmlLogger.LOG.configurationError(e);
        }
        InputStream beansXmlInputStream = null;
        try {
            beansXmlInputStream = beansXml.openStream();
            InputSource source = new InputSource(beansXmlInputStream);
            if (source.getByteStream().available() == 0) {
                BeansXml beansXml2 = BeansXml.EMPTY_BEANS_XML;
                return beansXml2;
            }
            BeansXmlHandler handler = this.getHandler(beansXml);
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", BeansXmlParser.loadXsds());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                // empty catch block
            }
            parser.parse(source, (DefaultHandler)handler);
            BeansXml beansXml3 = handler.createBeansXml();
            return beansXml3;
        }
        catch (IOException e) {
            throw XmlLogger.LOG.loadError(beansXml, e);
        }
        catch (SAXException e) {
            throw XmlLogger.LOG.parsingError(beansXml, e);
        }
        finally {
            if (beansXmlInputStream != null) {
                try {
                    beansXmlInputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public BeansXml parse(Iterable<URL> urls) {
        return this.parse(urls, false);
    }

    public BeansXml parse(Iterable<URL> urls, boolean removeDuplicates) {
        return this.merge(urls, this.URL_TO_BEANS_XML_FUNCTION, removeDuplicates);
    }

    private <T> BeansXml merge(Iterable<? extends T> items, Function<T, BeansXml> function, boolean removeDuplicates) {
        ArrayList<Metadata<String>> alternatives = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> alternativeStereotypes = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> decorators = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> interceptors = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<Filter>> includes = new ArrayList<Metadata<Filter>>();
        ArrayList<Metadata<Filter>> excludes = new ArrayList<Metadata<Filter>>();
        URL beansXmlUrl = null;
        for (T item : items) {
            BeansXml beansXml = function.apply(item);
            this.addTo(alternatives, beansXml.getEnabledAlternativeClasses(), removeDuplicates);
            this.addTo(alternativeStereotypes, beansXml.getEnabledAlternativeStereotypes(), removeDuplicates);
            this.addTo(decorators, beansXml.getEnabledDecorators(), removeDuplicates);
            this.addTo(interceptors, beansXml.getEnabledInterceptors(), removeDuplicates);
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
            beansXmlUrl = beansXml.getUrl();
        }
        return new BeansXmlImpl(alternatives, alternativeStereotypes, decorators, interceptors, new ScanningImpl(includes, excludes), beansXmlUrl, BeanDiscoveryMode.ALL, null);
    }

    private void addTo(List<Metadata<String>> list, List<Metadata<String>> listToAdd, boolean removeDuplicates) {
        if (removeDuplicates) {
            ArrayList<Metadata<String>> filteredListToAdd = new ArrayList<Metadata<String>>(listToAdd.size());
            for (Metadata<String> metadata : listToAdd) {
                if (this.alreadyAdded(metadata, list)) continue;
                filteredListToAdd.add(metadata);
            }
            listToAdd = filteredListToAdd;
        }
        list.addAll(listToAdd);
    }

    private boolean alreadyAdded(Metadata<String> metadata, List<Metadata<String>> list) {
        for (Metadata<String> existing : list) {
            if (!existing.getValue().equals(metadata.getValue())) continue;
            return true;
        }
        return false;
    }

    private static InputSource[] loadXsds() {
        ArrayList<InputSource> xsds = new ArrayList<InputSource>();
        for (XmlSchema schema : XmlSchema.values()) {
            InputSource source = BeansXmlParser.loadXsd(schema.getFileName(), schema.getClassLoader());
            if (source == null) continue;
            xsds.add(source);
        }
        return xsds.toArray(EMPTY_INPUT_SOURCE_ARRAY);
    }

    private static InputSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }

    protected BeansXmlHandler getHandler(URL beansXml) {
        return new BeansXmlHandler(beansXml);
    }

    public BeansXml mergeExisting(Iterable<? extends BeanDeploymentArchive> beanArchives, boolean removeDuplicates) {
        return this.merge(beanArchives, BEAN_ARCHIVE_TO_BEANS_XML_FUNCTION, removeDuplicates);
    }

    public BeansXml mergeExistingDescriptors(Iterable<BeansXml> beanArchives, boolean removeDuplicates) {
        return this.merge(beanArchives, BEANS_XML_IDENTITY_FUNCTION, removeDuplicates);
    }
}

