/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeDisposerResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.InjectionPoints;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.SetMultimap;
import org.jboss.weld.util.reflection.Reflections;

public class BeanDeployerEnvironment {
    private final Set<SlimAnnotatedTypeContext<?>> annotatedTypes;
    private final Set<Class<?>> vetoedClasses;
    private final SetMultimap<Class<?>, AbstractClassBean<?>> classBeanMap;
    private final SetMultimap<WeldMethodKey, ProducerMethod<?, ?>> producerMethodBeanMap;
    private final Set<ProducerField<?, ?>> producerFields;
    private final Set<RIBean<?>> beans;
    private final Set<ObserverInitializationContext<?, ?>> observers;
    private final Set<DisposalMethod<?, ?>> allDisposalBeans;
    private final Set<DisposalMethod<?, ?>> resolvedDisposalBeans;
    private final Set<DecoratorImpl<?>> decorators;
    private final Set<InterceptorImpl<?>> interceptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;
    private final ClassTransformer classTransformer;
    private final Set<Type> newBeanTypes;
    private final BeanManagerImpl manager;

    protected BeanDeployerEnvironment(BeanManagerImpl manager) {
        this(new HashSet(), new HashSet(), SetMultimap.newConcurrentSetMultimap(), new HashSet(), SetMultimap.newConcurrentSetMultimap(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet<Type>(), manager);
    }

    protected BeanDeployerEnvironment(Set<SlimAnnotatedTypeContext<?>> annotatedTypes, Set<Class<?>> vetoedClasses, SetMultimap<Class<?>, AbstractClassBean<?>> classBeanMap, Set<ProducerField<?, ?>> producerFields, SetMultimap<WeldMethodKey, ProducerMethod<?, ?>> producerMethodBeanMap, Set<RIBean<?>> beans, Set<ObserverInitializationContext<?, ?>> observers, Set<DisposalMethod<?, ?>> allDisposalBeans, Set<DisposalMethod<?, ?>> resolvedDisposalBeans, Set<DecoratorImpl<?>> decorators, Set<InterceptorImpl<?>> interceptors, Set<Type> newBeanTypes, BeanManagerImpl manager) {
        this.annotatedTypes = annotatedTypes;
        this.vetoedClasses = vetoedClasses;
        this.classBeanMap = classBeanMap;
        this.producerFields = producerFields;
        this.producerMethodBeanMap = producerMethodBeanMap;
        this.beans = beans;
        this.observers = observers;
        this.allDisposalBeans = allDisposalBeans;
        this.resolvedDisposalBeans = resolvedDisposalBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver((Iterable<DisposalMethod<?, ?>>)allDisposalBeans, manager.getServices().get(WeldConfiguration.class));
        this.classTransformer = manager.getServices().get(ClassTransformer.class);
        this.newBeanTypes = newBeanTypes;
        this.manager = manager;
    }

    public void addAnnotatedType(SlimAnnotatedTypeContext<?> annotatedType) {
        this.annotatedTypes.add(annotatedType);
    }

    public void addAnnotatedTypes(Collection<SlimAnnotatedTypeContext<?>> annotatedTypes) {
        this.annotatedTypes.addAll(annotatedTypes);
    }

    public void addSyntheticAnnotatedType(SlimAnnotatedType<?> annotatedType, Extension extension) {
        this.addAnnotatedType(SlimAnnotatedTypeContext.of(annotatedType, extension));
    }

    public Set<SlimAnnotatedTypeContext<?>> getAnnotatedTypes() {
        return Collections.unmodifiableSet(this.annotatedTypes);
    }

    public void removeAnnotatedType(SlimAnnotatedTypeContext<?> annotatedType) {
        this.annotatedTypes.remove(annotatedType);
    }

    public void removeAnnotatedTypes(Collection<SlimAnnotatedTypeContext<?>> annotatedTypes) {
        this.annotatedTypes.removeAll(annotatedTypes);
    }

    public void vetoJavaClass(Class<?> javaClass) {
        this.vetoedClasses.add(javaClass);
    }

    public boolean isVetoed(Class<?> clazz) {
        return this.vetoedClasses.contains(clazz);
    }

    public Set<ProducerMethod<?, ?>> getProducerMethod(Class<?> declaringClass, MethodSignature signature) {
        WeldMethodKey key = new WeldMethodKey(declaringClass, signature);
        Set beans = (Set)this.producerMethodBeanMap.get(key);
        for (ProducerMethod producerMethod : beans) {
            producerMethod.initialize(this);
        }
        return beans;
    }

    public Set<AbstractClassBean<?>> getClassBeans(Class<?> clazz) {
        Set beans = (Set)this.classBeanMap.get(clazz);
        for (AbstractClassBean bean : beans) {
            bean.preInitialize();
        }
        return beans;
    }

    public void addProducerMethod(ProducerMethod<?, ?> bean) {
        ((Set)this.producerMethodBeanMap.get(WeldMethodKey.of(bean))).add(bean);
        this.addAbstractBean(bean);
    }

    public void addProducerField(ProducerField<?, ?> bean) {
        this.producerFields.add(bean);
        this.addAbstractBean(bean);
    }

    public void addExtension(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractClassBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            ((Set)this.classBeanMap.get(bean.getBeanClass())).add(bean);
        }
        this.addAbstractBean(bean);
    }

    public void addManagedBean(ManagedBean<?> bean) {
        this.addAbstractClassBean(bean);
    }

    public void addSessionBean(SessionBean<?> bean) {
        Preconditions.checkArgument(bean instanceof AbstractClassBean, bean);
        this.addAbstractClassBean((AbstractClassBean)((Object)bean));
    }

    public void addNewManagedBean(NewManagedBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractBean(AbstractBean<?, ?> bean) {
        this.beans.add(bean);
    }

    public void addDecorator(DecoratorImpl<?> bean) {
        this.decorators.add(bean);
    }

    public void addInterceptor(InterceptorImpl<?> bean) {
        this.interceptors.add(bean);
    }

    public void addDisposesMethod(DisposalMethod<?, ?> bean) {
        this.allDisposalBeans.add(bean);
        this.addNewBeansFromInjectionPoints(bean.getInjectionPoints());
    }

    public void addObserverMethod(ObserverInitializationContext<?, ?> observerInitializer) {
        this.observers.add(observerInitializer);
        this.addNewBeansFromInjectionPoints(observerInitializer.getObserver().getInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(AbstractBean<?, ?> bean) {
        this.addNewBeansFromInjectionPoints(bean.getInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(Set<? extends InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            Class rawType;
            WeldInjectionPointAttributes weldInjectionPoint = InjectionPoints.getWeldInjectionPoint(injectionPoint);
            if (weldInjectionPoint.getQualifier(New.class) == null || Event.class.equals(rawType = Reflections.getRawType(weldInjectionPoint.getType()))) continue;
            New _new = weldInjectionPoint.getQualifier(New.class);
            if (_new.value().equals(New.class)) {
                if (rawType.equals(Instance.class)) {
                    Type typeParameter = Reflections.getActualTypeArguments(weldInjectionPoint.getType())[0];
                    this.addNewBeanFromInjectionPoint(typeParameter);
                    continue;
                }
                this.addNewBeanFromInjectionPoint(weldInjectionPoint.getType());
                continue;
            }
            this.addNewBeanFromInjectionPoint(_new.value());
        }
    }

    private void addNewBeanFromInjectionPoint(Type baseType) {
        this.newBeanTypes.add(baseType);
    }

    public Set<? extends RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorImpl<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<InterceptorImpl<?>> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<ObserverInitializationContext<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethod<?, ?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public <X> Set<DisposalMethod<X, ?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> qualifiers, AbstractClassBean<X> declaringBean) {
        Set beans = (Set)Reflections.cast(this.disposalMethodResolver.resolve(new ResolvableBuilder(this.manager).addTypes(types).addQualifiers(qualifiers).setDeclaringBean(declaringBean).create(), true));
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }

    public void vetoBean(AbstractBean<?, ?> bean) {
        this.beans.remove(bean);
        if (bean instanceof AbstractClassBean) {
            ((Set)this.classBeanMap.get(bean.getBeanClass())).remove(bean);
            if (bean instanceof InterceptorImpl) {
                this.interceptors.remove(bean);
            }
            if (bean instanceof DecoratorImpl) {
                this.decorators.remove(bean);
            }
        }
        if (bean instanceof ProducerMethod) {
            ProducerMethod producerMethod = (ProducerMethod)Reflections.cast(bean);
            ((Set)this.producerMethodBeanMap.get(WeldMethodKey.of(producerMethod))).remove(producerMethod);
        }
        if (bean instanceof ProducerField) {
            this.producerFields.remove(bean);
        }
    }

    public Iterable<AbstractClassBean<?>> getClassBeans() {
        return this.classBeanMap.values();
    }

    public Iterable<ProducerMethod<?, ?>> getProducerMethodBeans() {
        return this.producerMethodBeanMap.values();
    }

    public Set<ProducerField<?, ?>> getProducerFields() {
        return Collections.unmodifiableSet(this.producerFields);
    }

    public void cleanup() {
        this.annotatedTypes.clear();
        this.vetoedClasses.clear();
        this.classBeanMap.clear();
        this.producerMethodBeanMap.clear();
        this.producerFields.clear();
        this.allDisposalBeans.clear();
        this.resolvedDisposalBeans.clear();
        this.beans.clear();
        this.decorators.clear();
        this.interceptors.clear();
        this.observers.clear();
        this.disposalMethodResolver.clear();
        this.newBeanTypes.clear();
    }

    public Set<Type> getNewBeanTypes() {
        return Collections.unmodifiableSet(this.newBeanTypes);
    }

    protected static class WeldMethodKey {
        private final Class<?> declaringClass;
        private final MethodSignature signature;

        static WeldMethodKey of(ProducerMethod<?, ?> producerMethod) {
            return new WeldMethodKey(producerMethod.getBeanClass(), producerMethod.getEnhancedAnnotated().getSignature());
        }

        WeldMethodKey(Class<?> clazz, MethodSignature signature) {
            this.declaringClass = clazz;
            this.signature = signature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeldMethodKey other = (WeldMethodKey)obj;
            if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
                return false;
            }
            return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
        }
    }
}

