/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Prioritized;
import javax.interceptor.InvocationContext;
import org.jboss.weld.bootstrap.events.BuilderInterceptorInstance;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;

class BuilderInterceptorBean
implements Interceptor<BuilderInterceptorInstance>,
Prioritized,
PassivationCapable {
    private final Set<Annotation> bindings;
    private static final Set<Type> types = ImmutableSet.of(new Type[]{BuilderInterceptorInstance.class, Object.class});
    private final int priority;
    private final InterceptionType interceptionType;
    private final Function<InvocationContext, Object> interceptorFunction;
    private final BiFunction<InvocationContext, Bean<?>, Object> interceptorMetadataFunction;
    private final BeanManagerImpl beanManager;

    private BuilderInterceptorBean(Set<Annotation> interceptorBindings, InterceptionType type, int priority, BeanManagerImpl beanManager, Function<InvocationContext, Object> interceptorFunction, BiFunction<InvocationContext, Bean<?>, Object> interceptorMetadataFunction) {
        this.interceptorFunction = interceptorFunction;
        this.interceptorMetadataFunction = interceptorMetadataFunction;
        this.priority = priority;
        this.interceptionType = type;
        this.bindings = ImmutableSet.copyOf(interceptorBindings);
        this.beanManager = beanManager;
    }

    public BuilderInterceptorBean(Set<Annotation> interceptorBindings, InterceptionType type, int priority, BeanManagerImpl beanManager, Function<InvocationContext, Object> interceptorFunction) {
        this(interceptorBindings, type, priority, beanManager, interceptorFunction, null);
    }

    public BuilderInterceptorBean(Set<Annotation> interceptorBindings, InterceptionType type, int priority, BeanManagerImpl beanManager, BiFunction<InvocationContext, Bean<?>, Object> interceptorFunction) {
        this(interceptorBindings, type, priority, beanManager, null, interceptorFunction);
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.bindings;
    }

    @Override
    public boolean intercepts(InterceptionType type) {
        return this.interceptionType.equals((Object)type);
    }

    @Override
    public Object intercept(InterceptionType type, BuilderInterceptorInstance builderInterceptorInstance, InvocationContext ctx) throws Exception {
        if (this.interceptorMetadataFunction != null) {
            return this.interceptorMetadataFunction.apply(ctx, builderInterceptorInstance.getInterceptedBean());
        }
        return this.interceptorFunction.apply(ctx);
    }

    @Override
    public Class<?> getBeanClass() {
        return BuilderInterceptorInstance.class;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public Set<Type> getTypes() {
        return types;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.emptySet();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return this.getBeanClass().toString() + this.interceptionType.name() + this.priority + Formats.formatAnnotations(this.bindings);
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    protected WeldCreationalContext<?> getParentCreationalContext(CreationalContext<BuilderInterceptorInstance> ctx) {
        WeldCreationalContext<?> parentContext;
        if (ctx instanceof WeldCreationalContext && (parentContext = ((WeldCreationalContext)ctx).getParentCreationalContext()) != null) {
            return parentContext;
        }
        throw BeanLogger.LOG.unableToDetermineParentCreationalContext(ctx);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public BuilderInterceptorInstance create(CreationalContext<BuilderInterceptorInstance> creationalContext) {
        if (this.interceptorMetadataFunction != null) {
            WeldCreationalContext<?> interceptorContext = this.getParentCreationalContext(creationalContext);
            Contextual<?> interceptedContextual = interceptorContext.getContextual();
            if (interceptedContextual instanceof Bean) {
                return new BuilderInterceptorInstance((Bean)interceptedContextual, this.beanManager.getContextId());
            }
            throw BeanLogger.LOG.cannotCreateContextualInstanceOfBuilderInterceptor(this);
        }
        return new BuilderInterceptorInstance();
    }

    @Override
    public void destroy(BuilderInterceptorInstance instance, CreationalContext<BuilderInterceptorInstance> creationalContext) {
    }

    @Override
    public String getId() {
        return this.getName();
    }
}

