/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.builder.AnnotatedTypeConfigurator;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bootstrap.events.ContainerEvent;
import org.jboss.weld.bootstrap.events.builder.AnnotatedTypeBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.AnnotatedTypeConfiguratorImpl;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;

public class ProcessAnnotatedTypeImpl<X>
extends ContainerEvent
implements ProcessAnnotatedType<X> {
    private final SlimAnnotatedType<X> originalAnnotatedType;
    private final BeanManagerImpl manager;
    private AnnotatedType<X> annotatedType;
    private AnnotatedTypeConfiguratorImpl<X> configurator;
    private boolean veto;
    private boolean annotatedTypeSet;

    public ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType) {
        this(beanManager, annotatedType, ProcessAnnotatedType.class);
    }

    protected ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType, Class<? extends ProcessAnnotatedType> rawType) {
        this.manager = beanManager;
        this.annotatedType = annotatedType;
        this.originalAnnotatedType = annotatedType;
    }

    @Override
    public AnnotatedType<X> getAnnotatedType() {
        this.checkWithinObserverNotification();
        return this.annotatedType;
    }

    public SlimAnnotatedType<X> getResultingAnnotatedType() {
        if (this.isDirty()) {
            return ClassTransformer.instance(this.manager).getUnbackedAnnotatedType(this.originalAnnotatedType, this.annotatedType);
        }
        return this.originalAnnotatedType;
    }

    public SlimAnnotatedType<X> getOriginalAnnotatedType() {
        return this.originalAnnotatedType;
    }

    @Override
    public void setAnnotatedType(AnnotatedType<X> type) {
        if (this.configurator != null) {
            throw new IllegalStateException("Configurator used");
        }
        this.checkWithinObserverNotification();
        if (type == null) {
            throw BootstrapLogger.LOG.annotationTypeNull(this);
        }
        this.replaceAnnotatedType(type);
        this.annotatedTypeSet = true;
        BootstrapLogger.LOG.setAnnotatedTypeCalled(this.getReceiver(), this.annotatedType, type);
    }

    @Override
    public AnnotatedTypeConfigurator<X> configureAnnotatedType() {
        if (this.annotatedTypeSet) {
            throw new IllegalStateException("setAnnotatedType() used");
        }
        this.checkWithinObserverNotification();
        if (this.configurator == null) {
            this.configurator = new AnnotatedTypeConfiguratorImpl<X>(this.annotatedType);
        }
        return this.configurator;
    }

    @Override
    public void veto() {
        this.checkWithinObserverNotification();
        this.veto = true;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isDirty() {
        return this.originalAnnotatedType != this.annotatedType;
    }

    @Override
    public void postNotify(Extension extension) {
        super.postNotify(extension);
        if (this.configurator != null) {
            this.replaceAnnotatedType(new AnnotatedTypeBuilderImpl<X>(this.configurator).build());
            this.configurator = null;
        }
        this.annotatedTypeSet = false;
    }

    public String toString() {
        return this.annotatedType.toString();
    }

    private void replaceAnnotatedType(AnnotatedType<X> type) {
        if (!this.originalAnnotatedType.getJavaClass().equals(type.getJavaClass())) {
            throw BootstrapLogger.LOG.annotatedTypeJavaClassMismatch(this.annotatedType.getJavaClass(), type.getJavaClass());
        }
        AnnotatedTypeValidator.validateAnnotatedType(type);
        this.annotatedType = type;
    }
}

