/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.builder.BeanConfigurator;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bootstrap.events.builder.BeanAttributesBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.BeanConfiguratorImpl;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;

public class BeanBuilderImpl<T> {
    private final BeanConfiguratorImpl<T> configurator;

    public BeanBuilderImpl(BeanConfiguratorImpl<T> configurator) {
        this.configurator = configurator;
    }

    public BeanConfigurator<T> configure() {
        return this.configurator;
    }

    public Bean<T> build() {
        return new ImmutableBean<T>(this.configurator);
    }

    public BeanManagerImpl getBeanManager() {
        return this.configurator.getBeanManager();
    }

    static class ImmutableBean<T>
    extends ForwardingBeanAttributes<T>
    implements Bean<T>,
    PassivationCapable {
        private final String id;
        private final BeanManagerImpl beanManager;
        private final Class<?> beanClass;
        private final BeanAttributes<T> attributes;
        private final Set<InjectionPoint> injectionPoints;
        private final BeanConfiguratorImpl.CreateCallback<T> createCallback;
        private final BeanConfiguratorImpl.DestroyCallback<T> destroyCallback;

        ImmutableBean(BeanConfiguratorImpl<T> configurator) {
            this.beanManager = configurator.getBeanManager();
            this.beanClass = configurator.getBeanClass();
            this.attributes = new BeanAttributesBuilderImpl<T>(configurator.getAttributes()).build();
            this.injectionPoints = ImmutableSet.copyOf(configurator.getInjectionPoints());
            this.createCallback = configurator.getCreateCallback();
            this.destroyCallback = configurator.getDestroyCallback();
            this.id = configurator.getId() != null ? configurator.getId() : BeanIdentifiers.forBuilderBean(this.attributes, this.beanClass);
        }

        @Override
        public T create(CreationalContext<T> creationalContext) {
            return this.createCallback.create(creationalContext, this.beanManager);
        }

        @Override
        public void destroy(T instance, CreationalContext<T> creationalContext) {
            if (this.destroyCallback != null) {
                this.destroyCallback.destroy(instance, creationalContext);
            }
        }

        @Override
        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        protected BeanAttributes<T> attributes() {
            return this.attributes;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return "Immutable Builder Bean [" + this.getBeanClass().toString() + ", types: " + Formats.formatTypes(this.getTypes()) + ", qualifiers: " + Formats.formatAnnotations(this.getQualifiers()) + "]";
        }
    }
}

