/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.collections.SetMultimap;

public final class BeanArchives {
    public static final String BEAN_ARCHIVE_ID_BASE_DELIMITER = "_";

    private BeanArchives() {
    }

    public static <B extends BeanDeploymentArchive> Multimap<String, BeanDeploymentArchive> findBeanClassesDeployedInMultipleBeanArchives(Set<B> beanArchives) {
        SetMultimap<String, BeanDeploymentArchive> problems;
        block7: {
            block6: {
                if (beanArchives.size() == 1) {
                    return Multimaps.emptyMultimap();
                }
                problems = SetMultimap.newSetMultimap();
                if (beanArchives.size() != 2) break block6;
                Iterator<B> iterator = beanArchives.iterator();
                BeanDeploymentArchive first = (BeanDeploymentArchive)iterator.next();
                BeanDeploymentArchive second = (BeanDeploymentArchive)iterator.next();
                HashSet<String> intersection = new HashSet<String>(first.getBeanClasses());
                intersection.retainAll(second.getBeanClasses());
                if (intersection.isEmpty()) break block7;
                List<BeanDeploymentArchive> bdas = ImmutableList.of(new BeanDeploymentArchive[]{first, second});
                for (String beanClass : intersection) {
                    problems.putAll((Object)beanClass, bdas);
                }
                break block7;
            }
            if (beanArchives.size() > 2) {
                SetMultimap beanClassOccurrences = SetMultimap.newSetMultimap();
                for (BeanDeploymentArchive beanArchive : beanArchives) {
                    for (String beanClass : beanArchive.getBeanClasses()) {
                        beanClassOccurrences.put(beanClass, beanArchive);
                    }
                }
                for (Map.Entry entry : beanClassOccurrences.entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    problems.putAll(entry.getKey(), (Collection)entry.getValue());
                }
            }
        }
        return problems;
    }

    public static String extractBeanArchiveId(String beanArchiveRef, String base, String separator) {
        beanArchiveRef = beanArchiveRef.replace('\\', '/');
        StringBuilder id = new StringBuilder();
        id.append(base);
        id.append(BEAN_ARCHIVE_ID_BASE_DELIMITER);
        if (beanArchiveRef.contains(separator)) {
            id.append(beanArchiveRef.substring(beanArchiveRef.indexOf(separator), beanArchiveRef.length()));
        }
        return id.toString();
    }
}

