/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.BootstrapStats;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.probe.Queries;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.collections.SetMultimap;

class Probe {
    private static final int DEFAULT_INVOCATIONS_LIMIT = 5000;
    private static final int DEFAULT_EVENTS_LIMIT = 5000;
    private final Map<Bean<?>, String> beanToId;
    private final Map<String, Bean<?>> idToBean;
    private final Map<Bean<?>, BeanManagerImpl> beanToManager;
    private final Map<String, ObserverMethod<?>> idToObserver;
    private final Map<ObserverMethod<?>, String> observerToId;
    private final Map<BeanDeploymentArchive, BeanManagerImpl> bdaToManager;
    private final SetMultimap<Bean<?>, AbstractProducerBean<?, ?, ?>> beanToDeclaredProducers;
    private final ConcurrentMap<Integer, Invocation> invocations;
    private final List<EventInfo> events;
    private final Comparator<Bean<?>> beanComparator;
    private final Comparator<ObserverMethod<?>> observerComparator;
    private final Comparator<BeanDeploymentArchive> bdaComparator;
    private final AtomicLong initTs = new AtomicLong(0L);
    private final BootstrapStats bootstrapStats;

    Probe() {
        this.invocations = new ConcurrentHashMap<Integer, Invocation>();
        this.events = Collections.synchronizedList(new LinkedList());
        this.beanToId = new HashMap();
        this.idToBean = new HashMap();
        this.beanToManager = new HashMap();
        this.idToObserver = new HashMap();
        this.observerToId = new HashMap();
        this.beanToDeclaredProducers = SetMultimap.newSetMultimap();
        this.bdaToManager = new HashMap<BeanDeploymentArchive, BeanManagerImpl>();
        this.beanComparator = new Comparator<Bean<?>>(){

            @Override
            public int compare(Bean<?> o1, Bean<?> o2) {
                if (o1.getBeanClass().equals(o2.getBeanClass())) {
                    return ((String)Probe.this.beanToId.get(o1)).compareTo((String)Probe.this.beanToId.get(o2));
                }
                return o1.getBeanClass().getName().compareTo(o2.getBeanClass().getName());
            }
        };
        this.observerComparator = new Comparator<ObserverMethod<?>>(){

            @Override
            public int compare(ObserverMethod<?> o1, ObserverMethod<?> o2) {
                if (o1.getBeanClass().equals(o2.getBeanClass())) {
                    return ((String)Probe.this.observerToId.get(o1)).compareTo((String)Probe.this.observerToId.get(o2));
                }
                return o1.getBeanClass().getName().compareTo(o2.getBeanClass().getName());
            }
        };
        this.bdaComparator = new Comparator<BeanDeploymentArchive>(){

            @Override
            public int compare(BeanDeploymentArchive bda1, BeanDeploymentArchive bda2) {
                int result = Boolean.compare(bda2.getId().contains("WEB-INF/classes"), bda1.getId().contains("WEB-INF/classes"));
                if (result == 0 && (result = Boolean.compare(bda1.getId().endsWith(".additionalClasses"), bda2.getId().endsWith(".additionalClasses"))) == 0) {
                    result = Components.getNumberOfEnabledBeans((BeanManagerImpl)Probe.this.bdaToManager.get(bda2)).compareTo(Components.getNumberOfEnabledBeans((BeanManagerImpl)Probe.this.bdaToManager.get(bda1)));
                }
                return result == 0 ? bda1.getId().compareTo(bda2.getId()) : result;
            }
        };
        this.bootstrapStats = new BootstrapStats();
    }

    void init(BeanManagerImpl beanManager) {
        ContextualStore contextualStore = beanManager.getServices().get(ContextualStore.class);
        this.bdaToManager.putAll(Container.instance(beanManager).beanDeploymentArchives());
        for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : this.bdaToManager.entrySet()) {
            ProbeLogger.LOG.processingBeanDeploymentArchive(entry.getKey().getId());
            BeanManagerImpl manager = entry.getValue();
            for (Bean<?> bean : manager.getBeans()) {
                if (bean instanceof ExtensionBean) {
                    ExtensionBean extensionBean = (ExtensionBean)bean;
                    if (this.idToBean.containsValue(extensionBean)) continue;
                    this.putBean(Components.getId(extensionBean.getIdentifier()), manager, extensionBean);
                    continue;
                }
                if (bean instanceof AbstractBuiltInBean) {
                    String id = Components.getBuiltinBeanId((AbstractBuiltInBean)bean);
                    if (this.idToBean.containsKey(id)) continue;
                    this.putBean(id, bean);
                    continue;
                }
                if (!manager.isBeanEnabled(bean)) continue;
                this.putBean(contextualStore, manager, bean);
            }
            for (Interceptor interceptor : manager.getInterceptors()) {
                this.putBean(contextualStore, manager, interceptor);
            }
            for (Decorator decorator : manager.getDecorators()) {
                this.putBean(contextualStore, manager, decorator);
            }
            int customObservers = 0;
            for (ObserverMethod<?> observerMethod : manager.getObservers()) {
                if (observerMethod instanceof ObserverMethodImpl) {
                    ObserverMethodImpl observerMethodImpl = (ObserverMethodImpl)observerMethod;
                    this.putObserver(Components.getId(observerMethodImpl.getId()), observerMethodImpl);
                    continue;
                }
                this.putObserver(Components.getId("" + customObservers++), observerMethod);
            }
        }
        for (Bean bean : this.idToBean.values()) {
            Components.BeanKind kind = Components.BeanKind.from(bean);
            if (!Components.BeanKind.PRODUCER_FIELD.equals((Object)kind) && !Components.BeanKind.PRODUCER_METHOD.equals((Object)kind) && !Components.BeanKind.RESOURCE.equals((Object)kind) || !(bean instanceof AbstractProducerBean)) continue;
            AbstractProducerBean producerBean = (AbstractProducerBean)bean;
            this.beanToDeclaredProducers.put(producerBean.getDeclaringBean(), (Object)producerBean);
        }
        this.initTs.set(System.currentTimeMillis());
    }

    List<Bean<?>> getBeans() {
        ArrayList data = new ArrayList(this.idToBean.values());
        Collections.sort(data, this.beanComparator);
        return data;
    }

    String getBeanId(Bean<?> bean) {
        return this.beanToId.get(bean);
    }

    Bean<?> getBean(String id) {
        return this.idToBean.get(id);
    }

    BeanManagerImpl getBeanManager(Bean<?> bean) {
        return this.beanToManager.get(bean);
    }

    List<ObserverMethod<?>> getObservers() {
        ArrayList observers = new ArrayList(this.idToObserver.values());
        Collections.sort(observers, this.observerComparator);
        return observers;
    }

    String getObserverId(ObserverMethod<?> observerMethod) {
        return this.observerToId.get(observerMethod);
    }

    ObserverMethod<?> getObserver(String id) {
        return this.idToObserver.get(id);
    }

    Set<AbstractProducerBean<?, ?, ?>> getDeclaredProducers(Bean<?> bean) {
        return this.beanToDeclaredProducers.containsKey(bean) ? (Set)this.beanToDeclaredProducers.get(bean) : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInvocation(Invocation invocation) {
        if (!invocation.isEntryPoint()) {
            throw new IllegalStateException("Invocation is not an entry point!");
        }
        if (this.invocations.size() > 5000) {
            Probe probe = this;
            synchronized (probe) {
                if (this.invocations.size() > 5000) {
                    Set keySet = this.invocations.keySet();
                    ArrayList sorted = new ArrayList(keySet);
                    Collections.sort(sorted, Collections.reverseOrder());
                    if (keySet.removeAll(sorted.subList(2500, sorted.size()))) {
                        ProbeLogger.LOG.monitoringLimitExceeded(Invocation.class.getSimpleName(), 5000);
                    }
                }
            }
        }
        this.invocations.put(invocation.getEntryPointIdx(), invocation);
    }

    List<Invocation> getInvocations() {
        ArrayList<Invocation> sorted = new ArrayList<Invocation>(this.invocations.values());
        Collections.sort(sorted, Invocation.Comparators.ENTRY_POINT_IDX);
        return sorted;
    }

    Invocation getInvocation(String id) {
        try {
            return (Invocation)this.invocations.get(Integer.valueOf(id));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    int clearInvocations() {
        int size = this.invocations.size();
        this.invocations.clear();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(EventInfo event) {
        if (this.events.size() > 5000) {
            Probe probe = this;
            synchronized (probe) {
                if (this.events.size() > 5000) {
                    this.events.subList(0, 2500).clear();
                    ProbeLogger.LOG.monitoringLimitExceeded(EventInfo.class.getSimpleName(), 5000);
                }
            }
        }
        this.events.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventInfo> getEvents() {
        List<EventInfo> list = this.events;
        synchronized (list) {
            ArrayList<EventInfo> result = new ArrayList<EventInfo>(this.events.size());
            ListIterator<EventInfo> iterator = this.events.listIterator(this.events.size());
            while (iterator.hasPrevious()) {
                result.add(iterator.previous());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int clearEvents() {
        List<EventInfo> list = this.events;
        synchronized (list) {
            int count = this.events.size();
            this.events.clear();
            return count;
        }
    }

    Comparator<Bean<?>> getBeanComparator() {
        return this.beanComparator;
    }

    Comparator<ObserverMethod<?>> getObserverComparator() {
        return this.observerComparator;
    }

    Comparator<BeanDeploymentArchive> getBdaComparator() {
        return this.bdaComparator;
    }

    boolean isInitialized() {
        return this.initTs.get() != 0L;
    }

    long getInitTs() {
        return this.initTs.get();
    }

    BootstrapStats getBootstrapStats() {
        return this.bootstrapStats;
    }

    int getApplicationBeansCount() {
        return Queries.find(this.getBeans(), 0, 0, new Queries.BeanFilters(this, "probe-filterAdditionalBdas")).getTotal();
    }

    int getApplicationObserversCount() {
        return Queries.find(this.getObservers(), 0, 0, new Queries.ObserverFilters(this, null, "probe-filterAdditionalBdas")).getTotal();
    }

    int getInvocationsCount() {
        return this.invocations.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFiredEventsCount() {
        List<EventInfo> list = this.events;
        synchronized (list) {
            return this.events.size();
        }
    }

    private void putBean(ContextualStore contextualStore, Bean<?> bean) {
        this.putBean(Components.getId(contextualStore.putIfAbsent(bean)), bean);
    }

    private void putBean(String id, Bean<?> bean) {
        this.idToBean.put(id, bean);
        this.beanToId.put(bean, id);
    }

    private void putBean(String id, BeanManagerImpl manager, Bean<?> bean) {
        this.putBean(id, bean);
        this.beanToManager.put(bean, manager);
    }

    private void putBean(ContextualStore contextualStore, BeanManagerImpl manager, Bean<?> bean) {
        this.putBean(contextualStore, bean);
        this.beanToManager.put(bean, manager);
    }

    private void putObserver(String id, ObserverMethod<?> observerMethod) {
        this.idToObserver.put(id, observerMethod);
        this.observerToId.put(observerMethod, id);
    }
}

