/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.builder;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.builder.BeanAttributesConfigurator;
import javax.inject.Named;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.events.builder.BeanAttributesConfiguratorImpl;
import org.jboss.weld.util.collections.ImmutableSet;

public class BeanAttributesBuilderImpl<T> {
    static final Set<Annotation> DEFAULT_QUALIFIERS = ImmutableSet.of(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE});
    private final BeanAttributesConfiguratorImpl<T> configurator;

    public BeanAttributesBuilderImpl(BeanAttributesConfiguratorImpl<T> configurator) {
        this.configurator = configurator;
    }

    public BeanAttributesConfigurator<T> configure() {
        return this.configurator;
    }

    public BeanAttributes<T> build() {
        return new ImmutableBeanAttributes(ImmutableSet.copyOf(this.configurator.getStereotypes()), this.configurator.isAlternative(), this.configurator.getName(), this.initQualifiers(this.configurator.getQualifiers()), ImmutableSet.copyOf(this.configurator.getTypes()), this.initScope(this.configurator));
    }

    private Class<? extends Annotation> initScope(BeanAttributesConfiguratorImpl<T> configurator) {
        return configurator.getScope() != null ? configurator.getScope() : Dependent.class;
    }

    private Set<Annotation> initQualifiers(Set<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return DEFAULT_QUALIFIERS;
        }
        Set<Annotation> normalized = new HashSet<Annotation>(qualifiers);
        normalized.remove(Any.Literal.INSTANCE);
        normalized.remove(Default.Literal.INSTANCE);
        if (normalized.isEmpty()) {
            normalized = DEFAULT_QUALIFIERS;
        } else {
            ImmutableSet.Builder<Annotation> builder = ImmutableSet.builder();
            if (normalized.size() == 1 && qualifiers.iterator().next().annotationType().equals(Named.class)) {
                builder.add(Default.Literal.INSTANCE);
            }
            builder.add(Any.Literal.INSTANCE);
            builder.addAll((Iterable<Annotation>)qualifiers);
            normalized = builder.build();
        }
        return normalized;
    }
}

