/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.security.GetDeclaredMethodAction;
import org.jboss.weld.util.bytecode.BytecodeUtils;

public class DefaultBytecodeMethodResolver
implements BytecodeMethodResolver {
    private static final AtomicLong METHOD_COUNT = new AtomicLong();
    private static final String FIELD_NAME = "weld_proxy_field$$$";
    public static final String LJAVA_LANG_REFLECT_METHOD = "Ljava/lang/reflect/Method;";

    @Override
    public void getDeclaredMethod(ClassMethod classMethod, String declaringClass, String methodName, String[] parameterTypes, ClassMethod staticConstructor) {
        String fieldName = FIELD_NAME + METHOD_COUNT.incrementAndGet();
        staticConstructor.getClassFile().addField(10, fieldName, LJAVA_LANG_REFLECT_METHOD);
        CodeAttribute code = staticConstructor.getCodeAttribute();
        BytecodeUtils.pushClassType(code, declaringClass);
        code.ldc(methodName);
        code.iconst(parameterTypes.length);
        code.anewarray(Class.class.getName());
        for (int i = 0; i < parameterTypes.length; ++i) {
            code.dup();
            code.iconst(i);
            String type = parameterTypes[i];
            BytecodeUtils.pushClassType(code, type);
            code.aastore();
        }
        code.invokestatic(GetDeclaredMethodAction.class.getName(), "of", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Lorg/jboss/weld/security/GetDeclaredMethodAction;");
        code.invokestatic(AccessController.class.getName(), "doPrivileged", "(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        code.checkcast(Method.class);
        code.putstatic(classMethod.getClassFile().getName(), fieldName, LJAVA_LANG_REFLECT_METHOD);
        CodeAttribute methodCode = classMethod.getCodeAttribute();
        methodCode.getstatic(classMethod.getClassFile().getName(), fieldName, LJAVA_LANG_REFLECT_METHOD);
    }
}

