/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.servlet.logging.Category;

@MessageLogger(projectCode="WELD-ENV-")
public interface TomcatLogger
extends WeldEnvironmentLogger {
    public static final TomcatLogger LOG = Logger.getMessageLogger(TomcatLogger.class, Category.TOMCAT.getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1100, value="Tomcat 7+ detected, CDI injection will be available in Servlets, Filters and Listeners.")
    public void allInjectionsAvailable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1101, value="Tomcat 7+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported.")
    public void listenersInjectionsNotAvailable();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1102, value="Unable to replace Tomcat 7 AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners.")
    public void unableToReplaceTomcat(@Cause Throwable var1);

    @Message(id=1103, value="Cannot create WeldForwardingAnnotationProcessor.")
    public RuntimeException cannotCreatWeldForwardingAnnotationProcessor(@Cause Throwable var1);

    @Message(id=1104, value="Cannot get StandardContext from ServletContext.")
    public RuntimeException cannotGetStandardContext(@Cause Throwable var1);

    @Message(id=1105, value="Neither field nor setter found for instanceManager.")
    public RuntimeException neitherFieldNorSetterFound();
}

