/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.FieldResourceInjection;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.injection.SetterResourceInjection;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JaxwsInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.ApiAbstraction;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;

public final class ResourceInjectionFactory {
    private static final ResourceInjectionFactory INSTANCE = new ResourceInjectionFactory();
    private final List<ResourceInjectionProcessor<?, ?>> resourceInjectionProcessors = this.initializeProcessors();

    private ResourceInjectionFactory() {
    }

    public static ResourceInjectionFactory instance() {
        return INSTANCE;
    }

    public List<Set<ResourceInjection<?>>> getResourceInjections(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        ArrayList result = new ArrayList();
        for (EnhancedAnnotatedType<?> actualType = type; actualType != null && !actualType.getJavaClass().equals(Object.class); actualType = actualType.getEnhancedSuperclass()) {
            Set<ResourceInjection<?>> resourceInjections = this.discoverType(declaringBean, actualType, manager);
            if (resourceInjections.isEmpty()) continue;
            result.add(resourceInjections);
        }
        Collections.reverse(result);
        return result;
    }

    public <T, X> ResourceInjection<T> getStaticProducerFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, BeanManagerImpl beanManager) {
        ResourceInjectionProcessor<?, ?> processor;
        ResourceInjection<T> resourceInjection = null;
        Iterator<ResourceInjectionProcessor<?, ?>> iterator = this.resourceInjectionProcessors.iterator();
        while (iterator.hasNext() && (resourceInjection = (processor = iterator.next()).createStaticProducerFieldResourceInjection(fieldInjectionPoint, beanManager)) == null) {
        }
        return resourceInjection;
    }

    private List<ResourceInjectionProcessor<?, ?>> initializeProcessors() {
        ArrayList processors = new ArrayList();
        processors.add(new EjbResourceInjectionProcessor());
        processors.add(new PersistenceUnitResourceInjectionProcessor());
        processors.add(new PersistenceContextResourceInjectionProcessor());
        processors.add(new ResourceResourceInjectionProcessor());
        processors.add(new WebServiceResourceInjectionProcessor());
        return processors;
    }

    private Set<ResourceInjection<?>> discoverType(Bean<?> bean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
        HashSet resourceInjections = new HashSet();
        for (ResourceInjectionProcessor<?, ?> processor : this.resourceInjectionProcessors) {
            resourceInjections.addAll(processor.createResourceInjections(bean, type, manager));
        }
        return resourceInjections;
    }

    private class WebServiceResourceInjectionProcessor
    extends ResourceInjectionProcessor<JaxwsInjectionServices, WSApiAbstraction> {
        private WebServiceResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JaxwsInjectionServices injectionServices, WSApiAbstraction apiAbstraction) {
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerWebServiceRefInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(WSApiAbstraction apiAbstraction) {
            return apiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS;
        }

        @Override
        protected WSApiAbstraction getApiAbstraction(BeanManagerImpl manager) {
            return manager.getServices().get(WSApiAbstraction.class);
        }

        @Override
        protected JaxwsInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return manager.getServices().get(JaxwsInjectionServices.class);
        }
    }

    private class ResourceResourceInjectionProcessor
    extends ResourceInjectionProcessor<ResourceInjectionServices, EJBApiAbstraction> {
        private ResourceResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, ResourceInjectionServices injectionServices, EJBApiAbstraction apiAbstraction) {
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerResourceInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(EJBApiAbstraction apiAbstraction) {
            return apiAbstraction.RESOURCE_ANNOTATION_CLASS;
        }

        @Override
        protected EJBApiAbstraction getApiAbstraction(BeanManagerImpl manager) {
            return manager.getServices().get(EJBApiAbstraction.class);
        }

        @Override
        protected ResourceInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return manager.getServices().get(ResourceInjectionServices.class);
        }
    }

    private class PersistenceContextResourceInjectionProcessor
    extends ResourceInjectionProcessor<JpaInjectionServices, PersistenceApiAbstraction> {
        private PersistenceContextResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JpaInjectionServices injectionServices, PersistenceApiAbstraction apiAbstraction) {
            if (!injectionPoint.getType().equals(apiAbstraction.ENTITY_MANAGER_CLASS)) {
                throw BeanLogger.LOG.invalidResourceProducerType(injectionPoint.getAnnotated(), apiAbstraction.ENTITY_MANAGER_CLASS);
            }
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceContextInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction apiAbstraction) {
            return apiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
        }

        @Override
        protected PersistenceApiAbstraction getApiAbstraction(BeanManagerImpl manager) {
            return manager.getServices().get(PersistenceApiAbstraction.class);
        }

        @Override
        protected JpaInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return manager.getServices().get(JpaInjectionServices.class);
        }
    }

    private class PersistenceUnitResourceInjectionProcessor
    extends ResourceInjectionProcessor<JpaInjectionServices, PersistenceApiAbstraction> {
        private PersistenceUnitResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, JpaInjectionServices injectionServices, PersistenceApiAbstraction apiAbstraction) {
            if (!injectionPoint.getType().equals(apiAbstraction.ENTITY_MANAGER_FACTORY_CLASS)) {
                throw BeanLogger.LOG.invalidResourceProducerType(injectionPoint.getAnnotated(), apiAbstraction.ENTITY_MANAGER_FACTORY_CLASS);
            }
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerPersistenceUnitInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(PersistenceApiAbstraction apiAbstraction) {
            return apiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS;
        }

        @Override
        protected PersistenceApiAbstraction getApiAbstraction(BeanManagerImpl manager) {
            return manager.getServices().get(PersistenceApiAbstraction.class);
        }

        @Override
        protected JpaInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return manager.getServices().get(JpaInjectionServices.class);
        }
    }

    private class EjbResourceInjectionProcessor
    extends ResourceInjectionProcessor<EjbInjectionServices, EJBApiAbstraction> {
        private EjbResourceInjectionProcessor() {
        }

        @Override
        protected <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint injectionPoint, EjbInjectionServices injectionServices, EJBApiAbstraction apiAbstraction) {
            return (ResourceReferenceFactory)Reflections.cast(injectionServices.registerEjbInjectionPoint(injectionPoint));
        }

        @Override
        protected Class<? extends Annotation> getMarkerAnnotation(EJBApiAbstraction apiAbstraction) {
            return apiAbstraction.EJB_ANNOTATION_CLASS;
        }

        @Override
        protected EJBApiAbstraction getApiAbstraction(BeanManagerImpl manager) {
            return manager.getServices().get(EJBApiAbstraction.class);
        }

        @Override
        protected EjbInjectionServices getInjectionServices(BeanManagerImpl manager) {
            return manager.getServices().get(EjbInjectionServices.class);
        }
    }

    private abstract class ResourceInjectionProcessor<S extends Service, A extends ApiAbstraction> {
        private ResourceInjectionProcessor() {
        }

        protected <T, X> ResourceInjection<T> createStaticProducerFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, BeanManagerImpl beanManager) {
            S injectionServices = this.getInjectionServices(beanManager);
            A apiAbstraction = this.getApiAbstraction(beanManager);
            if (injectionServices != null && apiAbstraction != null && fieldInjectionPoint.getAnnotated().isAnnotationPresent(this.getMarkerAnnotation(apiAbstraction))) {
                return this.createFieldResourceInjection(fieldInjectionPoint, injectionServices, apiAbstraction);
            }
            return null;
        }

        protected Set<ResourceInjection<?>> createResourceInjections(Bean<?> declaringBean, EnhancedAnnotatedType<?> type, BeanManagerImpl manager) {
            S injectionServices = this.getInjectionServices(manager);
            A apiAbstraction = this.getApiAbstraction(manager);
            if (injectionServices == null || apiAbstraction == null) {
                return Collections.emptySet();
            }
            Class<Annotation> marker = this.getMarkerAnnotation(apiAbstraction);
            ImmutableSet.Builder<ResourceInjection<?>> resourceInjections = ImmutableSet.builder();
            for (EnhancedAnnotatedField<?, ?> enhancedAnnotatedField : type.getDeclaredEnhancedFields(marker)) {
                resourceInjections.add(this.createFieldResourceInjection(InjectionPointFactory.silentInstance().createFieldInjectionPoint(enhancedAnnotatedField, declaringBean, type.getJavaClass(), manager), injectionServices, apiAbstraction));
            }
            for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : type.getDeclaredEnhancedMethods(marker)) {
                if (enhancedAnnotatedMethod.getParameters().size() != 1) {
                    throw UtilLogger.LOG.resourceSetterInjectionNotAJavabean(enhancedAnnotatedMethod);
                }
                resourceInjections.add(this.createSetterResourceInjection(InjectionPointFactory.silentInstance().createParameterInjectionPoint(enhancedAnnotatedMethod.getEnhancedParameters().get(0), declaringBean, type.getJavaClass(), manager), injectionServices, apiAbstraction));
            }
            return resourceInjections.build();
        }

        private <T, X> ResourceInjection<T> createFieldResourceInjection(FieldInjectionPoint<T, X> fieldInjectionPoint, S injectionServices, A apiAbstraction) {
            return new FieldResourceInjection<T, X>(fieldInjectionPoint, (ResourceReferenceFactory)Reflections.cast(this.getResourceReferenceFactory(fieldInjectionPoint, injectionServices, apiAbstraction)));
        }

        private <T, X> ResourceInjection<T> createSetterResourceInjection(ParameterInjectionPoint<T, X> parameterInjectionPoint, S injectionServices, A apiAbstraction) {
            return new SetterResourceInjection<T, X>(parameterInjectionPoint, (ResourceReferenceFactory)Reflections.cast(this.getResourceReferenceFactory(parameterInjectionPoint, injectionServices, apiAbstraction)));
        }

        protected abstract <T> ResourceReferenceFactory<T> getResourceReferenceFactory(InjectionPoint var1, S var2, A var3);

        protected abstract Class<? extends Annotation> getMarkerAnnotation(A var1);

        protected abstract A getApiAbstraction(BeanManagerImpl var1);

        protected abstract S getInjectionServices(BeanManagerImpl var1);
    }
}

