/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public abstract class TypeSafeResolver<R extends Resolvable, T, C extends Collection<T>> {
    private static final long RESOLVED_CACHE_UPPER_BOUND = Long.getLong("org.jboss.weld.resolution.cacheSize", 0x100000L);
    private static final long DEFAULT_RESOLVED_CACHE_UPPER_BOUND = 0x100000L;
    private final ComputingCache<R, C> resolved;
    private final Iterable<? extends T> allBeans;
    private final ResolvableToBeanCollection<R, T, C> resolverFunction = new ResolvableToBeanCollection(this);

    public TypeSafeResolver(Iterable<? extends T> allBeans) {
        this.resolved = ComputingCacheBuilder.newBuilder().setMaxSize(RESOLVED_CACHE_UPPER_BOUND).build(this.resolverFunction);
        this.allBeans = allBeans;
    }

    public void clear() {
        this.resolved.clear();
    }

    public C resolve(R resolvable, boolean cache) {
        R wrappedResolvable = this.wrap(resolvable);
        if (cache) {
            return (C)((Collection)this.resolved.getValue(wrappedResolvable));
        }
        return this.resolverFunction.apply(wrappedResolvable);
    }

    private Set<T> findMatching(R resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean : this.getAllBeans(resolvable)) {
            if (!this.matches(resolvable, bean)) continue;
            result.add(bean);
        }
        return result;
    }

    protected Iterable<? extends T> getAllBeans(R resolvable) {
        return this.allBeans;
    }

    protected Iterable<? extends T> getAllBeans() {
        return this.allBeans;
    }

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract C sortResult(Set<T> var1);

    protected abstract boolean matches(R var1, T var2);

    protected C makeResultImmutable(C result) {
        if (result instanceof List) {
            return (C)((Collection)Reflections.cast(ImmutableList.copyOf((List)result)));
        }
        if (result instanceof Set) {
            return (C)((Collection)Reflections.cast(WeldCollections.immutableSetView((Set)result)));
        }
        throw new IllegalArgumentException("result");
    }

    protected R wrap(R resolvable) {
        return resolvable;
    }

    public boolean isCached(R resolvable) {
        return this.resolved.getValueIfPresent(this.wrap(resolvable)) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Resolver\n");
        sb.append("Resolved injection points: ").append(this.resolved.size()).append('\n');
        return sb.toString();
    }

    private static class ResolvableToBeanCollection<R extends Resolvable, T, C extends Collection<T>>
    implements Function<R, C> {
        private final TypeSafeResolver<R, T, C> resolver;

        private ResolvableToBeanCollection(TypeSafeResolver<R, T, C> resolver) {
            this.resolver = resolver;
        }

        @Override
        public C apply(R from) {
            return this.resolver.makeResultImmutable(this.resolver.sortResult(this.resolver.filterResult(((TypeSafeResolver)this.resolver).findMatching(from))));
        }
    }
}

