/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableMap;
import org.jboss.weld.util.collections.ImmutableMapEntry;

public abstract class ImmutableMap<K, V>
extends AbstractImmutableMap<K, V> {
    ImmutableMap() {
    }

    public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
        Preconditions.checkNotNull(map);
        return ImmutableMap.builder().putAll(map).build();
    }

    public static <K, V> Builder<K, V> builder() {
        return new HashMapBuilder();
    }

    private static class HashMapBuilder<K, V>
    implements Builder<K, V> {
        private static final int DEFAULT_INITIAL_CAPACITY = 4;
        private static final float LOAD_FACTOR = 1.2f;
        private Map<K, V> map = new HashMap(4, 1.2f);

        private HashMapBuilder() {
        }

        @Override
        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<K, V> items) {
            this.map.putAll(items);
            return this;
        }

        @Override
        public Map<K, V> build() {
            if (this.map.isEmpty()) {
                return Collections.emptyMap();
            }
            if (this.map.size() == 1) {
                return new ImmutableMapEntry<K, V>(this.map.entrySet().iterator().next());
            }
            return Collections.unmodifiableMap(this.map);
        }
    }

    public static interface Builder<K, V> {
        public Builder<K, V> put(K var1, V var2);

        public Builder<K, V> putAll(Map<K, V> var1);

        public Map<K, V> build();
    }
}

