/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.interceptor.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStoreImpl;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.builtin.BeanManagerBean;
import org.jboss.weld.bean.builtin.BeanManagerImplBean;
import org.jboss.weld.bean.builtin.ContextBean;
import org.jboss.weld.bean.proxy.ProtectionDomainCache;
import org.jboss.weld.bean.proxy.util.SimpleProxyServices;
import org.jboss.weld.bootstrap.AdditionalServiceLoader;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ConcurrentValidator;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.DeploymentVisitor;
import org.jboss.weld.bootstrap.ExtensionBeanDeployer;
import org.jboss.weld.bootstrap.FastProcessAnnotatedTypeResolver;
import org.jboss.weld.bootstrap.MissingDependenciesRegistry;
import org.jboss.weld.bootstrap.SpecializationAndEnablementRegistry;
import org.jboss.weld.bootstrap.TypeDiscoveryConfigurationImpl;
import org.jboss.weld.bootstrap.UnsupportedObserverMethodException;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.WeldRuntime;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.AfterBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.AfterDeploymentValidationImpl;
import org.jboss.weld.bootstrap.events.AfterTypeDiscoveryImpl;
import org.jboss.weld.bootstrap.events.BeforeBeanDiscoveryImpl;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEventPreloader;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.RequiredAnnotationDiscovery;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.DependentContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundConversationContextImpl;
import org.jboss.weld.context.bound.BoundLiteral;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundRequestContextImpl;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.BoundSessionContextImpl;
import org.jboss.weld.context.ejb.EjbLiteral;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.context.ejb.EjbRequestContextImpl;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpLiteral;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.context.http.HttpSessionContextImpl;
import org.jboss.weld.context.http.HttpSessionDestructionContext;
import org.jboss.weld.context.http.LazyHttpConversationContextImpl;
import org.jboss.weld.context.unbound.ApplicationContextImpl;
import org.jboss.weld.context.unbound.DependentContextImpl;
import org.jboss.weld.context.unbound.RequestContextImpl;
import org.jboss.weld.context.unbound.SingletonContextImpl;
import org.jboss.weld.context.unbound.UnboundLiteral;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.GlobalObserverNotifierService;
import org.jboss.weld.executor.ExecutorServicesFactory;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.SLSBInvocationInjectionPoint;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.VersionLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.BeanManagerLookupService;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.DefaultResourceLoader;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.ReflectionCacheFactory;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.SingleThreadScheduledExecutorServiceFactory;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ScheduledExecutorServiceFactory;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.serialization.ContextualStoreImpl;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.servlet.ServletContextService;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.servlet.spi.helpers.AcceptingHttpContextActivationFilter;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Permissions;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.jboss.weld.util.reflection.instantiation.LoaderInstantiatorFactory;

public class WeldStartup {
    private BeanManagerImpl deploymentManager;
    private BeanDeploymentArchiveMapping bdaMapping;
    private Collection<ContextHolder<? extends Context>> contexts;
    private Iterable<Metadata<Extension>> extensions;
    private Environment environment;
    private Deployment deployment;
    private DeploymentVisitor deploymentVisitor;
    private final ServiceRegistry initialServices = new SimpleServiceRegistry();
    private String contextId;

    public WeldRuntime startContainer(String contextId, Environment environment, Deployment deployment) {
        if (deployment == null) {
            throw BootstrapLogger.LOG.deploymentRequired();
        }
        this.checkApiVersion();
        Container.currentId.set(contextId);
        this.contextId = contextId;
        if (this.extensions == null) {
            this.extensions = deployment.getExtensions();
        }
        ServiceRegistry registry = deployment.getServices();
        this.setupInitialServices();
        registry.addAll(this.initialServices.entrySet());
        new AdditionalServiceLoader(deployment).loadAdditionalServices(registry);
        if (!registry.contains(ResourceLoader.class)) {
            registry.add(ResourceLoader.class, DefaultResourceLoader.INSTANCE);
        }
        WeldConfiguration configuration = new WeldConfiguration(registry.get(BootstrapConfiguration.class), registry.get(ExternalConfiguration.class), deployment);
        registry.add(WeldConfiguration.class, configuration);
        if (!registry.contains(InstantiatorFactory.class)) {
            registry.add(InstantiatorFactory.class, new LoaderInstantiatorFactory(configuration));
        }
        if (!registry.contains(ScheduledExecutorServiceFactory.class)) {
            registry.add(ScheduledExecutorServiceFactory.class, new SingleThreadScheduledExecutorServiceFactory());
        }
        if (!registry.contains(ProxyServices.class)) {
            registry.add(ProxyServices.class, new SimpleProxyServices());
        }
        this.addImplementationServices(registry);
        WeldStartup.verifyServices(registry, environment.getRequiredDeploymentServices());
        if (!registry.contains(TransactionServices.class)) {
            BootstrapLogger.LOG.jtaUnavailable();
        }
        this.deployment = deployment;
        this.environment = environment;
        this.deploymentManager = BeanManagerImpl.newRootManager(contextId, "deployment", registry);
        Container.initialize(contextId, this.deploymentManager, ServiceRegistries.unmodifiableServiceRegistry(deployment.getServices()));
        this.getContainer().setState(ContainerState.STARTING);
        this.contexts = this.createContexts(registry);
        this.bdaMapping = new BeanDeploymentArchiveMapping();
        this.deploymentVisitor = new DeploymentVisitor(this.deploymentManager, environment, deployment, this.contexts, this.bdaMapping);
        if (deployment instanceof CDI11Deployment) {
            registry.add(BeanManagerLookupService.class, new BeanManagerLookupService((CDI11Deployment)deployment, this.bdaMapping.getBdaToBeanManagerMap()));
        } else {
            BootstrapLogger.LOG.legacyDeploymentMetadataProvided();
        }
        this.deploymentVisitor.visit();
        Container.currentId.remove();
        return new WeldRuntime(contextId, this.deploymentManager, this.bdaMapping.getBdaToBeanManagerMap());
    }

    private void checkApiVersion() {
        if (Bean.class.getInterfaces().length == 1) {
            throw BootstrapLogger.LOG.cdiApiVersionMismatch();
        }
    }

    private void setupInitialServices() {
        if (this.initialServices.contains(TypeStore.class)) {
            return;
        }
        TypeStore store = new TypeStore();
        SharedObjectCache cache = new SharedObjectCache();
        ReflectionCache reflectionCache = ReflectionCacheFactory.newInstance(store);
        ClassTransformer classTransformer = new ClassTransformer(store, cache, reflectionCache, this.contextId);
        this.initialServices.add(TypeStore.class, store);
        this.initialServices.add(SharedObjectCache.class, cache);
        this.initialServices.add(ReflectionCache.class, reflectionCache);
        this.initialServices.add(ClassTransformer.class, classTransformer);
    }

    private void addImplementationServices(ServiceRegistry services) {
        services.add(SlimAnnotatedTypeStore.class, new SlimAnnotatedTypeStoreImpl());
        if (services.get(ClassTransformer.class) == null) {
            throw new IllegalStateException(ClassTransformer.class.getSimpleName() + " not installed.");
        }
        services.add(MemberTransformer.class, new MemberTransformer(services.get(ClassTransformer.class)));
        services.add(MetaAnnotationStore.class, new MetaAnnotationStore(services.get(ClassTransformer.class)));
        BeanIdentifierIndex beanIdentifierIndex = new BeanIdentifierIndex();
        services.add(BeanIdentifierIndex.class, beanIdentifierIndex);
        services.add(ContextualStore.class, new ContextualStoreImpl(this.contextId, beanIdentifierIndex));
        services.add(CurrentInjectionPoint.class, new CurrentInjectionPoint());
        services.add(SLSBInvocationInjectionPoint.class, new SLSBInvocationInjectionPoint());
        services.add(CurrentEventMetadata.class, new CurrentEventMetadata());
        services.add(SpecializationAndEnablementRegistry.class, new SpecializationAndEnablementRegistry());
        services.add(MissingDependenciesRegistry.class, new MissingDependenciesRegistry());
        GlobalObserverNotifierService observerNotificationService = new GlobalObserverNotifierService(services, this.contextId);
        services.add(GlobalObserverNotifierService.class, observerNotificationService);
        ExecutorServices executor = services.get(ExecutorServices.class);
        if (executor == null && (executor = ExecutorServicesFactory.create(DefaultResourceLoader.INSTANCE, services.get(WeldConfiguration.class))) != null) {
            services.add(ExecutorServices.class, executor);
        }
        services.add(RequiredAnnotationDiscovery.class, new RequiredAnnotationDiscovery(services.get(ReflectionCache.class)));
        WeldConfiguration configuration = services.get(WeldConfiguration.class);
        if (configuration.getBooleanProperty(ConfigurationKey.CONCURRENT_DEPLOYMENT).booleanValue() && services.contains(ExecutorServices.class)) {
            services.add(Validator.class, new ConcurrentValidator(executor));
        } else {
            services.add(Validator.class, new Validator());
        }
        ContainerLifecycleEventPreloader preloader = null;
        int preloaderThreadPoolSize = configuration.getIntegerProperty(ConfigurationKey.PRELOADER_THREAD_POOL_SIZE);
        if (preloaderThreadPoolSize > 0 && Permissions.hasPermission(Permissions.MODIFY_THREAD_GROUP)) {
            preloader = new ContainerLifecycleEventPreloader(preloaderThreadPoolSize, observerNotificationService.getGlobalLenientObserverNotifier());
        }
        services.add(ContainerLifecycleEvents.class, new ContainerLifecycleEvents(preloader, services.get(RequiredAnnotationDiscovery.class)));
        services.add(GlobalEnablementBuilder.class, new GlobalEnablementBuilder());
        if (!services.contains(HttpContextActivationFilter.class)) {
            services.add(HttpContextActivationFilter.class, AcceptingHttpContextActivationFilter.INSTANCE);
        }
        services.add(ServletContextService.class, new ServletContextService());
        services.add(ProtectionDomainCache.class, new ProtectionDomainCache());
    }

    private void installFastProcessAnnotatedTypeResolver(ServiceRegistry services) {
        ClassFileServices classFileServices = services.get(ClassFileServices.class);
        if (classFileServices != null) {
            GlobalObserverNotifierService observers = services.get(GlobalObserverNotifierService.class);
            try {
                FastProcessAnnotatedTypeResolver resolver = new FastProcessAnnotatedTypeResolver(observers.getAllObserverMethods());
                services.add(FastProcessAnnotatedTypeResolver.class, resolver);
            }
            catch (UnsupportedObserverMethodException e) {
                BootstrapLogger.LOG.notUsingFastResolver(e.getObserver());
                return;
            }
        }
    }

    public void startInitialization() {
        if (this.deploymentManager == null) {
            throw BootstrapLogger.LOG.managerNotInitialized();
        }
        HashSet<BeanDeployment> physicalBeanDeploymentArchives = new HashSet<BeanDeployment>(this.getBeanDeployments());
        ExtensionBeanDeployer extensionBeanDeployer = new ExtensionBeanDeployer(this.deploymentManager, this.deployment, this.bdaMapping, this.contexts);
        extensionBeanDeployer.addExtensions(this.extensions);
        extensionBeanDeployer.deployBeans();
        this.installFastProcessAnnotatedTypeResolver(this.deploymentManager.getServices());
        this.deploymentManager.addBean(new BeanManagerBean(this.deploymentManager));
        this.deploymentManager.addBean(new BeanManagerImplBean(this.deploymentManager));
        this.deploymentVisitor.visit();
        BeforeBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.bdaMapping, this.contexts);
        for (BeanDeployment beanDeployment : physicalBeanDeploymentArchives) {
            beanDeployment.createClasses();
        }
        this.deploymentVisitor.visit();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.createTypes();
        }
        AfterTypeDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.bdaMapping, this.contexts);
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.createEnablement();
        }
    }

    public void deployBeans() {
        for (BeanDeployment deployment : this.getBeanDeployments()) {
            deployment.createBeans(this.environment);
        }
        for (BeanDeployment deployment : this.getBeanDeployments()) {
            deployment.getBeanDeployer().processClassBeanAttributes();
            deployment.getBeanDeployer().createProducersAndObservers();
        }
        for (BeanDeployment deployment : this.getBeanDeployments()) {
            deployment.getBeanDeployer().processProducerAttributes();
            deployment.getBeanDeployer().createNewBeans();
        }
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.deploySpecialized(this.environment);
        }
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.deployBeans(this.environment);
        }
        this.getContainer().setState(ContainerState.DISCOVERED);
        this.flushCaches();
        AfterBeanDiscoveryImpl.fire(this.deploymentManager, this.deployment, this.bdaMapping, this.contexts);
        this.flushCaches();
        this.deploymentVisitor.visit();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.getBeanManager().getServices().get(InjectionTargetService.class).initialize();
            beanDeployment.afterBeanDiscovery(this.environment);
        }
        this.getContainer().putBeanDeployments(this.bdaMapping);
        this.getContainer().setState(ContainerState.DEPLOYED);
    }

    public void validateBeans() {
        BootstrapLogger.LOG.validatingBeans();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            BeanManagerImpl beanManager = beanDeployment.getBeanManager();
            beanManager.getBeanResolver().clear();
            this.deployment.getServices().get(Validator.class).validateDeployment(beanManager, beanDeployment);
            beanManager.getServices().get(InjectionTargetService.class).validate();
        }
        this.getContainer().setState(ContainerState.VALIDATED);
        AfterDeploymentValidationImpl.fire(this.deploymentManager);
    }

    public void endInitialization() {
        this.deploymentManager.getServices().get(BeanIdentifierIndex.class).build(this.getBeansForBeanIdentifierIndex());
        this.flushCaches();
        this.deploymentManager.getServices().cleanupAfterBoot();
        this.deploymentManager.cleanupAfterBoot();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            BeanManagerImpl beanManager = beanDeployment.getBeanManager();
            beanManager.getInterceptorMetadataReader().cleanAfterBoot();
            beanManager.getServices().cleanupAfterBoot();
            beanManager.cleanupAfterBoot();
            for (Bean<?> bean : beanManager.getBeans()) {
                if (!(bean instanceof RIBean)) continue;
                RIBean riBean = (RIBean)bean;
                riBean.cleanupAfterBoot();
            }
            for (Decorator decorator : beanManager.getDecorators()) {
                if (!(decorator instanceof DecoratorImpl)) continue;
                ((DecoratorImpl)Reflections.cast(decorator)).cleanupAfterBoot();
            }
            for (javax.enterprise.inject.spi.Interceptor interceptor : beanManager.getInterceptors()) {
                if (!(interceptor instanceof InterceptorImpl)) continue;
                ((InterceptorImpl)Reflections.cast(interceptor)).cleanupAfterBoot();
            }
        }
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            beanDeployment.getBeanDeployer().cleanup();
        }
        this.getContainer().setState(ContainerState.INITIALIZED);
    }

    private void flushCaches() {
        this.deploymentManager.getBeanResolver().clear();
        this.deploymentManager.getAccessibleLenientObserverNotifier().clear();
        this.deploymentManager.getGlobalStrictObserverNotifier().clear();
        this.deploymentManager.getGlobalLenientObserverNotifier().clear();
        this.deploymentManager.getDecoratorResolver().clear();
        this.deploymentManager.getInterceptorResolver().clear();
        this.deploymentManager.getNameBasedResolver().clear();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            BeanManagerImpl beanManager = beanDeployment.getBeanManager();
            beanManager.getBeanResolver().clear();
            beanManager.getAccessibleLenientObserverNotifier().clear();
            beanManager.getDecoratorResolver().clear();
            beanManager.getInterceptorResolver().clear();
            beanManager.getNameBasedResolver().clear();
        }
    }

    private Collection<BeanDeployment> getBeanDeployments() {
        return this.bdaMapping.getBeanDeployments();
    }

    private Container getContainer() {
        return Container.instance(this.contextId);
    }

    protected Collection<ContextHolder<? extends Context>> createContexts(ServiceRegistry services) {
        ArrayList<ContextHolder<? extends Context>> contexts = new ArrayList<ContextHolder<? extends Context>>();
        BeanIdentifierIndex beanIdentifierIndex = services.get(BeanIdentifierIndex.class);
        contexts.add(new ContextHolder<ApplicationContext>(new ApplicationContextImpl(this.contextId), ApplicationContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<SingletonContext>(new SingletonContextImpl(this.contextId), SingletonContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundSessionContext>(new BoundSessionContextImpl(this.contextId, beanIdentifierIndex), BoundSessionContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundConversationContext>(new BoundConversationContextImpl(this.contextId, beanIdentifierIndex), BoundConversationContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<BoundRequestContext>(new BoundRequestContextImpl(this.contextId), BoundRequestContext.class, BoundLiteral.INSTANCE));
        contexts.add(new ContextHolder<RequestContext>(new RequestContextImpl(this.contextId), RequestContext.class, UnboundLiteral.INSTANCE));
        contexts.add(new ContextHolder<DependentContext>(new DependentContextImpl(services.get(ContextualStore.class)), DependentContext.class, UnboundLiteral.INSTANCE));
        if (Reflections.isClassLoadable("javax.servlet.ServletContext", WeldClassLoaderResourceLoader.INSTANCE)) {
            contexts.add(new ContextHolder<HttpSessionContext>(new HttpSessionContextImpl(this.contextId, beanIdentifierIndex), HttpSessionContext.class, HttpLiteral.INSTANCE));
            contexts.add(new ContextHolder<HttpSessionDestructionContext>(new HttpSessionDestructionContext(this.contextId, beanIdentifierIndex), HttpSessionDestructionContext.class, HttpLiteral.INSTANCE));
            contexts.add(new ContextHolder<HttpConversationContext>(new LazyHttpConversationContextImpl(this.contextId, beanIdentifierIndex), HttpConversationContext.class, HttpLiteral.INSTANCE));
            contexts.add(new ContextHolder<HttpRequestContext>(new HttpRequestContextImpl(this.contextId), HttpRequestContext.class, HttpLiteral.INSTANCE));
        }
        if (this.isEjbServicesRegistered()) {
            contexts.add(new ContextHolder<EjbRequestContext>(new EjbRequestContextImpl(this.contextId), EjbRequestContext.class, EjbLiteral.INSTANCE));
        }
        for (ContextHolder contextHolder : contexts) {
            this.deploymentManager.addContext((Context)contextHolder.getContext());
            this.deploymentManager.addBean(ContextBean.of(contextHolder, this.deploymentManager));
        }
        return contexts;
    }

    protected static void verifyServices(ServiceRegistry services, Set<Class<? extends Service>> requiredServices) {
        for (Class<? extends Service> serviceType : requiredServices) {
            if (services.contains(serviceType)) continue;
            throw BootstrapLogger.LOG.unspecifiedRequiredService(serviceType.getName());
        }
    }

    public TypeDiscoveryConfiguration startExtensions(Iterable<Metadata<Extension>> extensions) {
        this.extensions = extensions;
        Set<Class<? extends Annotation>> beanDefiningAnnotations = ImmutableSet.of(new Class[]{Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, javax.decorator.Decorator.class, Model.class, NormalScope.class, Stereotype.class});
        return new TypeDiscoveryConfigurationImpl(beanDefiningAnnotations);
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        BeanDeployment beanDeployment = this.bdaMapping.getBeanDeployment(beanDeploymentArchive);
        return beanDeployment == null ? null : beanDeployment.getBeanManager().getCurrent();
    }

    private Set<Bean<?>> getBeansForBeanIdentifierIndex() {
        HashSet beans = new HashSet();
        for (BeanDeployment beanDeployment : this.getBeanDeployments()) {
            for (Bean<?> bean : beanDeployment.getBeanManager().getBeans()) {
                if (!bean.getScope().equals(SessionScoped.class) && !bean.getScope().equals(ConversationScoped.class)) continue;
                beans.add(bean);
            }
        }
        return beans;
    }

    private boolean isEjbServicesRegistered() {
        if (this.deployment.getServices().contains(EjbServices.class)) {
            return true;
        }
        for (BeanDeploymentArchive beanDeploymentArchive : this.deployment.getBeanDeploymentArchives()) {
            if (!beanDeploymentArchive.getServices().contains(EjbServices.class)) continue;
            return true;
        }
        return false;
    }

    static {
        VersionLogger.LOG.version(Formats.version(WeldBootstrap.class.getPackage()));
    }
}

