/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.Status;
import org.jboss.weld.event.TransactionNotificationSynchronization;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionalObserverNotifier
extends ObserverNotifier {
    private final TransactionServices transactionServices;
    private final String contextId;

    protected TransactionalObserverNotifier(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        super(resolver, services, strict);
        this.contextId = contextId;
        this.transactionServices = services.get(TransactionServices.class);
    }

    private <T> void deferNotification(T event, EventMetadata metadata, ObserverMethod<? super T> observer, List<DeferredEventNotification<?>> notifications) {
        TransactionPhase transactionPhase = observer.getTransactionPhase();
        boolean before = transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION);
        Status status = Status.valueOf(transactionPhase);
        notifications.add(new DeferredEventNotification<T>(this.contextId, event, metadata, observer, this.currentEventMetadata, status, before));
    }

    @Override
    protected <T> void notifyTransactionObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata) {
        if (observers.isEmpty()) {
            return;
        }
        if (this.transactionServices == null || !this.transactionServices.isTransactionActive()) {
            this.notifySyncObservers(observers, event, metadata);
        } else {
            ArrayList notifications = new ArrayList();
            for (ObserverMethod observerMethod : observers) {
                this.deferNotification(event, metadata, observerMethod, notifications);
            }
            this.transactionServices.registerSynchronization(new TransactionNotificationSynchronization(notifications));
        }
    }
}

