/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.util.List;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventMetadata;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.experimental.ExperimentalEventMetadata;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class ObserverMethodInvocationStrategy {
    private static final ObserverMethodInvocationStrategy DEFAULT_STRATEGY = new ObserverMethodInvocationStrategy(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T, X> void notify(Object receiver, MethodInjectionPoint<T, X> method, T event, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            boolean release;
            boolean bl = release = creationalContext == null;
            if (release) {
                creationalContext = manager.createCreationalContext((Contextual)null);
            }
            try {
                method.invoke(receiver, event, manager, creationalContext, ObserverException.class);
            }
            finally {
                if (release) {
                    creationalContext.release();
                }
            }
        }
    };
    private static final ObserverMethodInvocationStrategy SIMPLE_STRATEGY = new ObserverMethodInvocationStrategy(){

        @Override
        public <T, X> void notify(Object receiver, MethodInjectionPoint<T, X> method, T event, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            method.invoke(receiver, event, manager, creationalContext, ObserverException.class);
        }
    };
    private static final ObserverMethodInvocationStrategy EVENT_PLUS_BEAN_MANAGER_STRATEGY = new ObserverMethodInvocationStrategy(){

        @Override
        public <T, X> void notify(Object receiver, MethodInjectionPoint<T, X> method, T event, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            method.invoke(receiver, new Object[]{event, new BeanManagerProxy(manager)}, ObserverException.class);
        }
    };

    public static ObserverMethodInvocationStrategy of(MethodInjectionPoint<?, ?> method, BeanManagerImpl manager) {
        List parameters = method.getParameterInjectionPoints();
        if (parameters.size() == 1 && ((ParameterInjectionPoint)parameters.get(0)).getAnnotated().isAnnotationPresent(Observes.class)) {
            return SIMPLE_STRATEGY;
        }
        if (parameters.size() == 2 && ((ParameterInjectionPoint)parameters.get(0)).getAnnotated().isAnnotationPresent(Observes.class)) {
            if (BeanManager.class.equals((Object)((ParameterInjectionPoint)parameters.get(1)).getType())) {
                return EVENT_PLUS_BEAN_MANAGER_STRATEGY;
            }
            if (EventMetadata.class.equals((Object)((ParameterInjectionPoint)parameters.get(1)).getType()) || ExperimentalEventMetadata.class.equals((Object)((ParameterInjectionPoint)parameters.get(1)).getType())) {
                return new EventPlusMetadataStrategy(manager);
            }
        }
        return DEFAULT_STRATEGY;
    }

    public abstract <T, X> void notify(Object var1, MethodInjectionPoint<T, X> var2, T var3, BeanManagerImpl var4, CreationalContext<?> var5);

    private static class EventPlusMetadataStrategy
    extends ObserverMethodInvocationStrategy {
        private final CurrentEventMetadata metadata;

        private EventPlusMetadataStrategy(BeanManagerImpl manager) {
            this.metadata = manager.getServices().get(CurrentEventMetadata.class);
        }

        @Override
        public <T, X> void notify(Object receiver, MethodInjectionPoint<T, X> method, T event, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            method.invoke(receiver, new Object[]{event, this.metadata.peek()}, ObserverException.class);
        }
    }
}

