/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.reflection.Reflections;

public class DisposalMethod<X, T> {
    private static final String DISPOSER_ANNOTATION = "@Disposes";
    private final BeanManagerImpl beanManager;
    private final AbstractClassBean<X> declaringBean;
    private final MethodInjectionPoint<T, ? super X> disposalMethodInjectionPoint;
    private final AnnotatedParameter<? super X> disposesParameter;
    private final Set<QualifierInstance> requiredQualifiers;

    public static <X, T> DisposalMethod<X, T> of(BeanManagerImpl manager, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        return new DisposalMethod<X, T>(manager, method, declaringBean);
    }

    protected DisposalMethod(BeanManagerImpl beanManager, EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod, AbstractClassBean<X> declaringBean) {
        this.disposalMethodInjectionPoint = InjectionPointFactory.instance().createMethodInjectionPoint(enhancedAnnotatedMethod, declaringBean, declaringBean.getBeanClass(), Disposes.class, beanManager);
        this.beanManager = beanManager;
        this.declaringBean = declaringBean;
        EnhancedAnnotatedParameter<?, X> enhancedDisposesParameter = this.getEnhancedDisposesParameter(enhancedAnnotatedMethod);
        this.disposesParameter = enhancedDisposesParameter.slim();
        this.requiredQualifiers = this.getRequiredQualifiers(enhancedDisposesParameter);
        this.checkDisposalMethod(enhancedAnnotatedMethod, declaringBean);
    }

    private EnhancedAnnotatedParameter<?, ? super X> getEnhancedDisposesParameter(EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod) {
        return enhancedAnnotatedMethod.getEnhancedParameters(Disposes.class).get(0);
    }

    public AnnotatedParameter<? super X> getDisposesParameter() {
        return this.disposesParameter;
    }

    public AnnotatedMethod<? super X> getAnnotated() {
        return this.disposalMethodInjectionPoint.getAnnotated();
    }

    public void invokeDisposeMethod(Object receiver, Object instance, CreationalContext<?> creationalContext) {
        this.disposalMethodInjectionPoint.invoke(receiver, instance, this.beanManager, creationalContext, IllegalArgumentException.class);
    }

    private void checkDisposalMethod(EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod, AbstractClassBean<X> declaringBean) {
        SessionBean sessionBean;
        Set<MethodSignature> businessMethodSignatures;
        if (enhancedAnnotatedMethod.getEnhancedParameters(Disposes.class).size() > 1) {
            throw BeanLogger.LOG.multipleDisposeParams(this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getEnhancedParameters(Observes.class).size() > 0) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod("@Observes", DISPOSER_ANNOTATION, this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Inject.class) != null) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod("@Inject", DISPOSER_ANNOTATION, this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Produces.class) != null) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod("@Produces", DISPOSER_ANNOTATION, this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Specializes.class) != null) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod("@Specialized", DISPOSER_ANNOTATION, this.disposalMethodInjectionPoint);
        }
        if (declaringBean instanceof SessionBean && !(businessMethodSignatures = (sessionBean = (SessionBean)declaringBean).getBusinessMethodSignatures()).contains(enhancedAnnotatedMethod.getSignature())) {
            throw BeanLogger.LOG.methodNotBusinessMethod(enhancedAnnotatedMethod, declaringBean);
        }
        for (ParameterInjectionPoint ip : this.disposalMethodInjectionPoint.getParameterInjectionPoints()) {
            Class rawType = Reflections.getRawType(ip.getType());
            if (!Bean.class.equals(rawType) && !Interceptor.class.equals(rawType) && !Decorator.class.equals(rawType)) continue;
            Validator.checkBeanMetadataInjectionPoint(this, ip, this.getDisposesParameter().getBaseType());
        }
    }

    public Type getGenericType() {
        return this.getDisposesParameter().getBaseType();
    }

    public Set<QualifierInstance> getRequiredQualifiers() {
        return this.requiredQualifiers;
    }

    public AbstractClassBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    public String toString() {
        return "Disposer method [" + this.getDisposesParameter().getDeclaringCallable() + "]";
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.disposalMethodInjectionPoint.getInjectionPoints();
    }

    private Set<QualifierInstance> getRequiredQualifiers(EnhancedAnnotatedParameter<?, ? super X> enhancedDisposedParameter) {
        Set<Annotation> disposedParameterQualifiers = enhancedDisposedParameter.getMetaAnnotations(Qualifier.class);
        if (disposedParameterQualifiers.isEmpty()) {
            disposedParameterQualifiers = Collections.singleton(DefaultLiteral.INSTANCE);
        }
        return this.beanManager.getServices().get(MetaAnnotationStore.class).getQualifierInstances(disposedParameterQualifiers);
    }
}

