/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.config;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.ConfigurationLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.security.GetSystemPropertyAction;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableMap;

public class WeldConfiguration
implements Service {
    public static final String CONFIGURATION_FILE = "weld.properties";
    private static final String EXECUTOR_CONFIGURATION_FILE = "org.jboss.weld.executor.properties";
    private static final String BOOTSTRAP_CONFIGURATION_FILE = "org.jboss.weld.bootstrap.properties";
    private static final String UNSAFE_PROXIES_MARKER = "META-INF/org.jboss.weld.enableUnsafeProxies";
    private final Map<ConfigurationKey, Object> properties;
    private final File proxyDumpFilePath;

    public WeldConfiguration(BootstrapConfiguration bootstrapConfiguration, ExternalConfiguration externalConfiguration, Deployment deployment) {
        Preconditions.checkArgumentNotNull(deployment, "deployment");
        this.properties = this.init(bootstrapConfiguration, externalConfiguration, deployment);
        this.proxyDumpFilePath = this.initProxyDumpFilePath();
        ConfigurationLogger.LOG.configurationInitialized(this.properties);
    }

    public String getStringProperty(ConfigurationKey key) {
        return this.getProperty(key, String.class);
    }

    public Boolean getBooleanProperty(ConfigurationKey key) {
        return this.getProperty(key, Boolean.class);
    }

    public Long getLongProperty(ConfigurationKey key) {
        return this.getProperty(key, Long.class);
    }

    public Integer getIntegerProperty(ConfigurationKey key) {
        return this.getProperty(key, Integer.class);
    }

    public File getProxyDumpFilePath() {
        return this.proxyDumpFilePath;
    }

    @Override
    public void cleanup() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    static void merge(Map<ConfigurationKey, Object> original, Map<ConfigurationKey, Object> toMerge) {
        for (Map.Entry<ConfigurationKey, Object> entry : toMerge.entrySet()) {
            Object existing = original.get((Object)entry.getKey());
            if (existing != null) {
                ConfigurationLogger.LOG.configurationKeyAlreadySet((Object)entry.getKey(), existing, entry.getValue());
                continue;
            }
            original.put(entry.getKey(), entry.getValue());
        }
    }

    static void checkRequiredType(ConfigurationKey key, Class<?> requiredType) {
        if (!key.isValidValueType(requiredType)) {
            throw ConfigurationLogger.LOG.configurationPropertyTypeMismatch(key.getDefaultValue().getClass(), requiredType);
        }
    }

    static String getSystemProperty(String key) {
        try {
            return AccessController.doPrivileged(new GetSystemPropertyAction(key));
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private Map<ConfigurationKey, Object> init(BootstrapConfiguration bootstrapConfiguration, ExternalConfiguration externalConfiguration, Deployment deployment) {
        EnumMap<ConfigurationKey, Object> properties = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        WeldConfiguration.merge(properties, this.readFileProperties(this.findPropertiesFiles(deployment, CONFIGURATION_FILE)));
        WeldConfiguration.merge(properties, this.readObsoleteFileProperties(this.findPropertiesFiles(deployment, BOOTSTRAP_CONFIGURATION_FILE), ImmutableMap.builder().put("concurrentDeployment", ConfigurationKey.CONCURRENT_DEPLOYMENT).put("preloaderThreadPoolSize", ConfigurationKey.PRELOADER_THREAD_POOL_SIZE).build()));
        WeldConfiguration.merge(properties, this.readObsoleteFileProperties(this.findPropertiesFiles(deployment, EXECUTOR_CONFIGURATION_FILE), ImmutableMap.builder().put("threadPoolSize", ConfigurationKey.EXECUTOR_THREAD_POOL_SIZE).put("threadPoolDebug", ConfigurationKey.EXECUTOR_THREAD_POOL_DEBUG).put("threadPoolType", ConfigurationKey.EXECUTOR_THREAD_POOL_TYPE).put("threadPoolKeepAliveTime", ConfigurationKey.EXECUTOR_THREAD_POOL_KEEP_ALIVE_TIME).build()));
        if (!this.findPropertiesFiles(deployment, UNSAFE_PROXIES_MARKER).isEmpty()) {
            WeldConfiguration.merge(properties, ImmutableMap.of(ConfigurationKey.RELAXED_CONSTRUCTION, true));
        }
        WeldConfiguration.merge(properties, this.getSystemProperties());
        WeldConfiguration.merge(properties, this.getObsoleteSystemProperties());
        WeldConfiguration.merge(properties, this.processExternalConfiguration(externalConfiguration));
        WeldConfiguration.merge(properties, this.processBootstrapConfiguration(bootstrapConfiguration));
        return properties;
    }

    private File initProxyDumpFilePath() {
        String dumpPath = this.getStringProperty(ConfigurationKey.PROXY_DUMP);
        if (!dumpPath.isEmpty()) {
            File tmp = new File(dumpPath);
            if (!tmp.isDirectory() && !tmp.mkdirs()) {
                BeanLogger.LOG.directoryCannotBeCreated(tmp.toString());
                return null;
            }
            return tmp;
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Set<URL> findPropertiesFiles(Deployment deployment, String fileName) {
        HashSet<ResourceLoader> resourceLoaders = new HashSet<ResourceLoader>();
        HashSet<URL> files = new HashSet<URL>();
        ResourceLoader deploymentResourceLoader = deployment.getServices().get(ResourceLoader.class);
        if (deploymentResourceLoader != null) {
            resourceLoaders.add(deploymentResourceLoader);
        }
        for (BeanDeploymentArchive archive : deployment.getBeanDeploymentArchives()) {
            ResourceLoader resourceLoader = archive.getServices().get(ResourceLoader.class);
            if (resourceLoader == null) {
                ConfigurationLogger.LOG.resourceLoaderNotSpecifiedForArchive(archive);
                continue;
            }
            resourceLoaders.add(resourceLoader);
        }
        for (ResourceLoader resourceLoader : resourceLoaders) {
            URL file = resourceLoader.getResource(fileName);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private Map<ConfigurationKey, Object> getSystemProperties() {
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (ConfigurationKey key : ConfigurationKey.values()) {
            String property = WeldConfiguration.getSystemProperty(key.get());
            if (property == null) continue;
            found.put(key, key.convertValue(property));
        }
        return found;
    }

    private Map<ConfigurationKey, Object> getObsoleteSystemProperties() {
        String preloaderThreadPoolSize;
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        String concurrentDeployment = WeldConfiguration.getSystemProperty("org.jboss.weld.bootstrap.properties.concurrentDeployment");
        if (concurrentDeployment != null) {
            found.put(ConfigurationKey.CONCURRENT_DEPLOYMENT, ConfigurationKey.CONCURRENT_DEPLOYMENT.convertValue(concurrentDeployment));
        }
        if ((preloaderThreadPoolSize = WeldConfiguration.getSystemProperty("org.jboss.weld.bootstrap.properties.preloaderThreadPoolSize")) != null) {
            found.put(ConfigurationKey.PRELOADER_THREAD_POOL_SIZE, ConfigurationKey.PRELOADER_THREAD_POOL_SIZE.convertValue(preloaderThreadPoolSize));
        }
        return found;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Map<ConfigurationKey, Object> readFileProperties(Set<URL> files) {
        if (files.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (URL file : files) {
            ConfigurationLogger.LOG.readingPropertiesFile(file);
            Properties fileProperties = this.loadProperties(file);
            for (String name : fileProperties.stringPropertyNames()) {
                this.handleStringKey(found, name, fileProperties.getProperty(name));
            }
        }
        return found;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Only local URLs involved")
    private Map<ConfigurationKey, Object> readObsoleteFileProperties(Set<URL> files, Map<String, ConfigurationKey> nameToKeyMap) {
        if (files.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (URL file : files) {
            Properties fileProperties = this.loadProperties(file);
            for (String name : fileProperties.stringPropertyNames()) {
                ConfigurationKey key = nameToKeyMap.get(name);
                if (key != null) {
                    Object value = key.convertValue(fileProperties.getProperty(name));
                    Object previous = found.put(key, value);
                    if (previous == null || previous.equals(value)) continue;
                    throw ConfigurationLogger.LOG.configurationKeyHasDifferentValues((Object)key, previous, value);
                }
                ConfigurationLogger.LOG.unsupportedConfigurationKeyFound(name + " in " + fileProperties);
            }
        }
        return found;
    }

    private Map<ConfigurationKey, Object> processBootstrapConfiguration(BootstrapConfiguration bootstrapConfiguration) {
        if (bootstrapConfiguration != null) {
            EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
            this.handleKey(found, ConfigurationKey.CONCURRENT_DEPLOYMENT, bootstrapConfiguration.isConcurrentDeploymentEnabled());
            this.handleKey(found, ConfigurationKey.PRELOADER_THREAD_POOL_SIZE, bootstrapConfiguration.getPreloaderThreadPoolSize());
            this.handleKey(found, ConfigurationKey.NON_PORTABLE_MODE, bootstrapConfiguration.isNonPortableModeEnabled());
        }
        return Collections.emptyMap();
    }

    private Map<ConfigurationKey, Object> processExternalConfiguration(ExternalConfiguration externalConfiguration) {
        if (externalConfiguration == null) {
            return Collections.emptyMap();
        }
        EnumMap<ConfigurationKey, Object> found = new EnumMap<ConfigurationKey, Object>(ConfigurationKey.class);
        for (Map.Entry<String, Object> entry : externalConfiguration.getConfigurationProperties().entrySet()) {
            this.handleStringKey(found, entry.getKey(), entry.getValue());
        }
        return found;
    }

    private void handleKey(Map<ConfigurationKey, Object> properties, ConfigurationKey key, Object value) {
        if (key.isValidValue(value)) {
            Object previous = properties.put(key, value);
            if (previous != null && !previous.equals(value)) {
                throw ConfigurationLogger.LOG.configurationKeyHasDifferentValues((Object)key, previous, value);
            }
        } else {
            throw ConfigurationLogger.LOG.invalidConfigurationPropertyValue(value, (Object)key);
        }
    }

    private void handleStringKey(Map<ConfigurationKey, Object> properties, String stringKey, Object value) {
        ConfigurationKey key = ConfigurationKey.fromString(stringKey);
        if (key != null) {
            this.handleKey(properties, key, value instanceof String ? key.convertValue((String)value) : value);
        } else {
            ConfigurationLogger.LOG.unsupportedConfigurationKeyFound(stringKey);
        }
    }

    private <T> T getProperty(ConfigurationKey key, Class<T> requiredType) {
        WeldConfiguration.checkRequiredType(key, requiredType);
        Object property = this.properties.get((Object)key);
        return (T)(property != null ? property : key.getDefaultValue());
    }

    private Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
        return properties;
    }
}

