/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.SimpleBeanIdentifierIndexNamingScheme;
import org.jboss.weld.context.beanstore.http.EagerSessionBeanStore;
import org.jboss.weld.context.beanstore.http.LazySessionBeanStore;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.serialization.BeanIdentifierIndex;

public class HttpSessionContextImpl
extends AbstractBoundContext<HttpServletRequest>
implements HttpSessionContext {
    static final String NAMING_SCHEME_PREFIX = "WELD_S";
    static final String KEY_BEAN_ID_INDEX_HASH = "WELD_S_HASH";
    private final NamingScheme namingScheme;
    private final String contextId;

    public HttpSessionContextImpl(String contextId, BeanIdentifierIndex index) {
        super(contextId, true);
        this.namingScheme = new SimpleBeanIdentifierIndexNamingScheme(NAMING_SCHEME_PREFIX, index);
        this.contextId = contextId;
    }

    @Override
    public boolean associate(HttpServletRequest request) {
        if (this.getBeanStore() != null) {
            ContextLogger.LOG.beanStoreLeakDuringAssociation(this.getClass().getName(), request);
        }
        this.setBeanStore(new LazySessionBeanStore(request, this.namingScheme));
        this.checkBeanIdentifierIndexConsistency(request);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy(HttpSession session) {
        if (this.getBeanStore() == null) {
            try {
                HttpConversationContext conversationContext = this.getConversationContext();
                this.setBeanStore(new EagerSessionBeanStore(this.namingScheme, session));
                this.activate();
                this.invalidate();
                conversationContext.destroy(session);
                this.deactivate();
                this.setBeanStore(null);
                boolean bl = true;
                return bl;
            }
            finally {
                this.cleanup();
            }
        }
        this.invalidate();
        this.getConversationContext().destroy(session);
        return false;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    protected HttpConversationContext getConversationContext() {
        return (HttpConversationContext)Container.instance(this.contextId).deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
    }

    protected Conversation getConversation() {
        return (Conversation)Container.instance(this.contextId).deploymentManager().instance().select(Conversation.class, new Annotation[0]).get();
    }

    private void checkBeanIdentifierIndexConsistency(HttpServletRequest request) {
        BeanIdentifierIndex index;
        HttpSession session = request.getSession(false);
        if (session != null && (index = this.getServiceRegistry().get(BeanIdentifierIndex.class)) != null && index.isBuilt()) {
            Object hash = session.getAttribute(KEY_BEAN_ID_INDEX_HASH);
            if (hash != null) {
                if (!index.getIndexHash().equals(hash)) {
                    throw ContextLogger.LOG.beanIdentifierIndexInconsistencyDetected();
                }
            } else {
                session.setAttribute(KEY_BEAN_ID_INDEX_HASH, (Object)index.getIndexHash());
            }
        }
    }
}

