/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.interceptor.InvocationContext;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.event.ContextEvent;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.LazyValueHolder;

public abstract class AbstractEJBRequestScopeActivationInterceptor
implements Serializable {
    private static final long serialVersionUID = 7327757031821596782L;
    private static final Object INITIALIZED_EVENT = new ContextEvent("Request context initialized for EJB invocation");
    private static final Object DESTROYED_EVENT = new ContextEvent("Request context destroyed after EJB invocation");
    private final LazyValueHolder<FastEvent<Object>> requestInitializedEvent = new LazyValueHolder.Serializable<FastEvent<Object>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected FastEvent<Object> computeValue() {
            return FastEvent.of(Object.class, AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager(), AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager().getGlobalLenientObserverNotifier(), InitializedLiteral.REQUEST);
        }
    };
    private final LazyValueHolder<FastEvent<Object>> requestDestroyedEvent = new LazyValueHolder.Serializable<FastEvent<Object>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected FastEvent<Object> computeValue() {
            return FastEvent.of(Object.class, AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager(), AbstractEJBRequestScopeActivationInterceptor.this.getBeanManager().getGlobalLenientObserverNotifier(), DestroyedLiteral.REQUEST);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (this.isRequestContextActive()) {
            return invocation.proceed();
        }
        EjbRequestContext requestContext = this.getEjbRequestContext();
        try {
            Object object;
            requestContext.associate(invocation);
            requestContext.activate();
            try {
                this.requestInitializedEvent.get().fire(INITIALIZED_EVENT);
                object = invocation.proceed();
            }
            catch (Throwable throwable) {
                requestContext.invalidate();
                requestContext.deactivate();
                throw throwable;
            }
            requestContext.invalidate();
            requestContext.deactivate();
            return object;
        }
        finally {
            requestContext.dissociate(invocation);
            this.requestDestroyedEvent.get().fire(DESTROYED_EVENT);
        }
    }

    protected boolean isRequestContextActive() {
        for (RequestContext requestContext : this.getBeanManager().instance().select(RequestContext.class, new Annotation[0])) {
            if (!requestContext.isActive()) continue;
            return true;
        }
        return false;
    }

    protected EjbRequestContext getEjbRequestContext() {
        return (EjbRequestContext)this.getBeanManager().instance().select(EjbRequestContext.class, new Annotation[0]).get();
    }

    protected abstract BeanManagerImpl getBeanManager();
}

