/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.logging;

import java.net.URL;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.environment.logging.Category;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.resources.spi.ClassFileInfoException;

@MessageLogger(projectCode="WELD-ENV-")
public interface CommonLogger
extends WeldEnvironmentLogger {
    public static final CommonLogger LOG = Logger.getMessageLogger(CommonLogger.class, Category.BOOTSTRAP.getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not read resource with name: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotReadResource(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader, expecting Web Start class loader", format=Message.Format.MESSAGE_FORMAT)
    public void unexpectedClassLoader(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="JNLPClassLoader#getJarFile(URL) threw exception", format=Message.Format.MESSAGE_FORMAT)
    public void jnlpClassLoaderInternalException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Could not invoke JNLPClassLoader#getJarFile(URL) on context class loader", format=Message.Format.MESSAGE_FORMAT)
    public void jnlpClassLoaderInvocationException(@Cause Throwable var1);

    @Message(id=7, value="Error handling file {0}", format=Message.Format.MESSAGE_FORMAT)
    public RuntimeException cannotHandleFile(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Error loading file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorLoadingFile(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Could not open the stream on the url {0} when adding to the jandex index.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotOpenStreamForURL(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Could not close the stream on the url {0} when adding to the jandex index.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotCloseStreamForURL(Object var1, @Cause Throwable var2);

    @Message(id=12, value="Unable to load class {0}", format=Message.Format.MESSAGE_FORMAT)
    public ClassFileInfoException unableToLoadClass(Object var1);

    @Message(id=13, value="beans.xml defines unrecognized bean-discovery-mode value: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException undefinedBeanDiscoveryValue(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Falling back to Java Reflection for bean-discovery-mode=\"annotated\" discovery. Add org.jboss:jandex to the classpath to speed-up startup.", format=Message.Format.MESSAGE_FORMAT)
    public void reflectionFallback();

    @Message(id=15, value="Unable to load annotation: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToLoadAnnotation(Object var1);

    @Message(id=16, value="Missing beans.xml file in META-INF", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException missingBeansXml();

    @Message(id=18, value="Unable to resolve a bean for {0} with bindings {1}", format=Message.Format.MESSAGE_FORMAT)
    public UnsatisfiedResolutionException unableToResolveBean(Object var1, Object var2);

    @Message(id=19, value="Jandex index is null in the constructor of class: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException jandexIndexNotCreated(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Using jandex for bean discovery", format=Message.Format.MESSAGE_FORMAT)
    public void usingJandex();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Could not close the stream for of the jandex index file for {0}.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotCloseStreamOfJandexIndex(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22, value="Found jandex index at {0}", format=Message.Format.MESSAGE_FORMAT)
    public void foundJandexIndex(URL var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=23, value="Archive isolation disabled - only one bean archive will be created", format=Message.Format.MESSAGE_FORMAT)
    public void archiveIsolationDisabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=24, value="Archive isolation enabled - creating multiple isolated bean archives if needed", format=Message.Format.MESSAGE_FORMAT)
    public void archiveIsolationEnabled();

    @Message(id=25, value="Index for name: {0} not found.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException indexForNameNotFound(Object var1);

    @Message(id=26, value="Unable to instantiate {0} using parameters: {1}.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToInstantiate(Object var1, Object var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Weld initialization skipped - no bean archive found")
    public void initSkippedNoBeanArchiveFound();

    @Message(id=29, value="Cannot load class for {0}.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException cannotLoadClass(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=30, value="Cannot load class using the ResourceLoader: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void cannotLoadClassUsingResourceLoader(String var1);
}

