/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.util.Servlets;
import org.jboss.weld.resources.spi.ResourceLoader;

public class WebAppBeanArchiveScanner
extends DefaultBeanArchiveScanner {
    static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    static final String WEB_INF_CLASSES_BEANS_XML = "/WEB-INF/classes/META-INF/beans.xml";
    static final String[] RESOURCES = new String[]{"/WEB-INF/beans.xml", "/WEB-INF/classes/META-INF/beans.xml"};
    static final String WEB_INF_CLASSES = "/WEB-INF/classes";
    private final ServletContext servletContext;

    public WebAppBeanArchiveScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, ServletContext servletContext) {
        super(resourceLoader, bootstrap);
        this.servletContext = servletContext;
    }

    @Override
    public Map<URL, BeanArchiveScanner.ScanResult> scan() {
        Map<URL, BeanArchiveScanner.ScanResult> beansXmlMap = super.scan();
        try {
            BeansXml beansXml;
            URL beansXmlUrl = null;
            for (String resource : RESOURCES) {
                URL resourceUrl = this.servletContext.getResource(resource);
                if (resourceUrl == null) continue;
                if (beansXmlUrl != null) {
                    WeldServletLogger.LOG.foundBothConfiguration(beansXmlUrl);
                    continue;
                }
                beansXmlUrl = resourceUrl;
            }
            if (beansXmlUrl != null && this.accept(beansXml = this.bootstrap.parse(beansXmlUrl))) {
                File webInfClasses = Servlets.getRealFile(this.servletContext, WEB_INF_CLASSES);
                if (webInfClasses != null) {
                    beansXmlMap.put(beansXmlUrl, new BeanArchiveScanner.ScanResult(beansXml, webInfClasses.getPath()));
                } else {
                    beansXmlMap.put(beansXmlUrl, new BeanArchiveScanner.ScanResult(beansXml, WEB_INF_CLASSES));
                }
            }
        }
        catch (MalformedURLException e) {
            throw WeldServletLogger.LOG.errorLoadingResources(e);
        }
        return beansXmlMap;
    }
}

