/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.ContextualInstance;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.experimental.ExperimentalEventMetadata;
import org.jboss.weld.experimental.ExperimentalObserverMethod;
import org.jboss.weld.experimental.Priority;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ObserverMethodInvocationStrategy;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.injection.attributes.WeldInjectionPointAttributes;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class ObserverMethodImpl<T, X>
implements ExperimentalObserverMethod<T> {
    private static final Type EVENT_METADATA_INSTANCE_TYPE = new TypeLiteral<Instance<EventMetadata>>(){}.getType();
    public static final String ID_PREFIX = ObserverMethodImpl.class.getPackage().getName();
    public static final String ID_SEPARATOR = "-";
    private final Set<Annotation> bindings;
    private final Type eventType;
    protected final BeanManagerImpl beanManager;
    private final Reception reception;
    protected final RIBean<X> declaringBean;
    protected final MethodInjectionPoint<T, ? super X> observerMethod;
    protected TransactionPhase transactionPhase;
    private final String id;
    private final Set<WeldInjectionPointAttributes<?, ?>> injectionPoints;
    private final Set<WeldInjectionPointAttributes<?, ?>> newInjectionPoints;
    private final int priority;
    private final boolean isStatic;
    private final boolean eventMetadataRequired;
    private final ObserverMethodInvocationStrategy notificationStrategy;

    protected ObserverMethodImpl(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        this.beanManager = manager;
        this.declaringBean = declaringBean;
        this.observerMethod = this.initMethodInjectionPoint(observer, declaringBean, manager);
        EnhancedAnnotatedParameter<?, X> eventParameter = observer.getEnhancedParameters(Observes.class).get(0);
        this.eventType = new HierarchyDiscovery(declaringBean.getBeanClass()).resolveType(eventParameter.getBaseType());
        this.id = ObserverMethodImpl.createId(observer, declaringBean);
        this.bindings = manager.getServices().get(SharedObjectCache.class).getSharedSet(observer.getEnhancedParameters(Observes.class).get(0).getMetaAnnotations(Qualifier.class));
        Observes observesAnnotation = observer.getEnhancedParameters(Observes.class).get(0).getAnnotation(Observes.class);
        this.reception = observesAnnotation.notifyObserver();
        this.transactionPhase = ObserverFactory.getTransactionalPhase(observer);
        ImmutableSet.Builder<ParameterInjectionPoint> injectionPoints = ImmutableSet.builder();
        ImmutableSet.Builder<ParameterInjectionPoint> newInjectionPoints = ImmutableSet.builder();
        for (ParameterInjectionPoint injectionPoint : this.observerMethod.getParameterInjectionPoints()) {
            if (injectionPoint instanceof SpecialParameterInjectionPoint) continue;
            if (injectionPoint.getQualifier(New.class) != null) {
                newInjectionPoints.add(injectionPoint);
            }
            injectionPoints.add(injectionPoint);
        }
        this.injectionPoints = injectionPoints.build();
        this.newInjectionPoints = newInjectionPoints.build();
        Priority priority = eventParameter.getAnnotation(Priority.class);
        this.priority = priority == null ? 2500 : priority.value();
        this.isStatic = observer.isStatic();
        this.eventMetadataRequired = ObserverMethodImpl.initMetadataRequired(this.injectionPoints);
        this.notificationStrategy = ObserverMethodInvocationStrategy.of(this.observerMethod, this.beanManager);
    }

    private static boolean initMetadataRequired(Set<WeldInjectionPointAttributes<?, ?>> injectionPoints) {
        for (WeldInjectionPointAttributes<?, ?> ip : injectionPoints) {
            Type type = ip.getType();
            if (!EventMetadata.class.equals((Object)type) && !ExperimentalEventMetadata.class.equals((Object)type) && !EVENT_METADATA_INSTANCE_TYPE.equals(type)) continue;
            return true;
        }
        return false;
    }

    protected static String createId(EnhancedAnnotatedMethod<?, ?> observer, RIBean<?> declaringBean) {
        String typeId = null;
        if (declaringBean instanceof AbstractClassBean) {
            AbstractClassBean classBean = (AbstractClassBean)declaringBean;
            typeId = ((AnnotatedTypeIdentifier)classBean.getAnnotated().getIdentifier()).asString();
        } else {
            typeId = declaringBean.getBeanClass().getName();
        }
        return ID_PREFIX + ID_SEPARATOR + ObserverMethod.class.getSimpleName() + ID_SEPARATOR + typeId + "." + observer.getSignature();
    }

    protected MethodInjectionPoint<T, ? super X> initMethodInjectionPoint(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        return InjectionPointFactory.instance().createMethodInjectionPoint(observer, declaringBean, declaringBean.getBeanClass(), Observes.class, manager);
    }

    public Set<WeldInjectionPointAttributes<?, ?>> getInjectionPoints() {
        return this.injectionPoints;
    }

    public Set<WeldInjectionPointAttributes<?, ?>> getNewInjectionPoints() {
        return this.newInjectionPoints;
    }

    private <Y> void checkObserverMethod(EnhancedAnnotatedMethod<T, Y> annotated) {
        List<EnhancedAnnotatedParameter<?, Y>> eventObjects = annotated.getEnhancedParameters(Observes.class);
        if (this.reception.equals((Object)Reception.IF_EXISTS) && this.declaringBean.getScope().equals(Dependent.class)) {
            throw EventLogger.LOG.invalidScopedConditionalObserver(this);
        }
        if (eventObjects.size() > 1) {
            throw EventLogger.LOG.multipleEventParameters(this);
        }
        EnhancedAnnotatedParameter<?, Y> eventParameter = eventObjects.iterator().next();
        this.checkRequiredTypeAnnotations(eventParameter);
        List<EnhancedAnnotatedParameter<?, Y>> disposeParams = annotated.getEnhancedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw EventLogger.LOG.invalidDisposesParameter(this);
        }
        if (this.observerMethod.getAnnotated().isAnnotationPresent(Produces.class)) {
            throw EventLogger.LOG.invalidProducer(this);
        }
        if (this.observerMethod.getAnnotated().isAnnotationPresent(Inject.class)) {
            throw EventLogger.LOG.invalidInitializer(this);
        }
        boolean containerLifecycleObserverMethod = Observers.isContainerLifecycleObserverMethod(this);
        for (EnhancedAnnotatedParameter parameter : annotated.getEnhancedParameters()) {
            if (!containerLifecycleObserverMethod || parameter.isAnnotationPresent(Observes.class) || BeanManager.class.equals((Object)parameter.getBaseType())) continue;
            throw EventLogger.LOG.invalidInjectionPoint(this);
        }
    }

    protected void checkRequiredTypeAnnotations(EnhancedAnnotatedParameter<?, ?> eventParameter) {
        if (eventParameter.isAnnotationPresent(WithAnnotations.class)) {
            throw EventLogger.LOG.invalidWithAnnotations(this);
        }
    }

    @Override
    public Class<X> getBeanClass() {
        return this.declaringBean.getType();
    }

    public RIBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    @Override
    public Reception getReception() {
        return this.reception;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this.bindings;
    }

    @Override
    public Type getObservedType() {
        return this.eventType;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public MethodInjectionPoint<T, ? super X> getMethod() {
        return this.observerMethod;
    }

    public void initialize(EnhancedAnnotatedMethod<T, ? super X> annotated) {
        this.checkObserverMethod(annotated);
    }

    @Override
    public void notify(T event) {
        this.sendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event) {
        if (this.isStatic) {
            this.sendEvent(event, null, null);
        } else {
            CreationalContext creationalContext = null;
            try {
                Object receiver = this.getReceiverIfExists(null);
                if (receiver == null && this.reception != Reception.IF_EXISTS) {
                    creationalContext = this.beanManager.createCreationalContext((Contextual)this.declaringBean);
                    receiver = this.getReceiverIfExists(creationalContext);
                }
                if (receiver != null) {
                    this.sendEvent(event, receiver, creationalContext);
                }
            }
            finally {
                if (creationalContext != null) {
                    creationalContext.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event, Object receiver, CreationalContext<?> creationalContext) {
        try {
            this.preNotify(event, receiver);
            this.notificationStrategy.notify(receiver, this.observerMethod, event, this.beanManager, creationalContext);
        }
        finally {
            this.postNotify(event, receiver);
            if (creationalContext != null) {
                creationalContext.release();
            }
        }
    }

    protected void preNotify(T event, Object receiver) {
    }

    protected void postNotify(T event, Object receiver) {
    }

    private Object getReceiverIfExists(CreationalContext<X> creationalContext) {
        try {
            return this.getReceiver(creationalContext);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    protected Object getReceiver(CreationalContext<X> creationalContext) {
        if (creationalContext != null) {
            if (creationalContext instanceof CreationalContextImpl) {
                creationalContext = ((CreationalContextImpl)creationalContext).getCreationalContext(this.declaringBean);
            }
            return ContextualInstance.get(this.declaringBean, this.beanManager, creationalContext);
        }
        return ContextualInstance.getIfExists(this.declaringBean, this.beanManager);
    }

    public String toString() {
        return this.observerMethod.toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObserverMethodImpl that = (ObserverMethodImpl)obj;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public boolean isEventMetadataRequired() {
        return this.eventMetadataRequired;
    }
}

