/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.weld.util.Preconditions;

class Json {
    private static final String NAME = "name";
    private static final String OBJECT_START = "{";
    private static final String OBJECT_END = "}";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String NAME_VAL_SEPARATOR = ":";
    private static final String ENTRY_SEPARATOR = ",";
    private static final char CHAR_QUOTATION_MARK = '\"';
    private static final char CHAR_REVERSE_SOLIDUS = '\\';

    private Json() {
    }

    public static JsonArrayBuilder newArrayBuilder() {
        return new JsonArrayBuilder();
    }

    public static JsonObjectBuilder newObjectBuilder() {
        return new JsonObjectBuilder();
    }

    static void appendValue(StringBuilder builder, Object value) {
        if (value instanceof JsonObjectBuilder) {
            builder.append(((JsonObjectBuilder)value).build());
        } else if (value instanceof JsonArrayBuilder) {
            builder.append(((JsonArrayBuilder)value).build());
        } else if (value instanceof String) {
            Json.appendStringValue(builder, value.toString());
        } else if (value instanceof Boolean || value instanceof Integer || value instanceof Long) {
            builder.append(value.toString());
        } else {
            throw new IllegalStateException("Unsupported value type: " + value);
        }
    }

    static void appendStringValue(StringBuilder builder, String value) {
        builder.append('\"');
        builder.append(Json.escape(value));
        builder.append('\"');
    }

    static String escape(String value) {
        StringBuilder builder = new StringBuilder();
        block3: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(c);
                    continue block3;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    static class JsonObjectBuilder
    extends JsonBuilder<JsonObjectBuilder> {
        private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

        private JsonObjectBuilder() {
        }

        JsonObjectBuilder add(String name, String value) {
            this.addInternal(name, value);
            return this;
        }

        JsonObjectBuilder add(String name, JsonObjectBuilder value) {
            this.addInternal(name, value);
            return this;
        }

        JsonObjectBuilder add(String name, JsonArrayBuilder value) {
            this.addInternal(name, value);
            return this;
        }

        JsonObjectBuilder add(String name, Boolean value) {
            this.addInternal(name, value);
            return this;
        }

        JsonObjectBuilder add(String name, Integer value) {
            this.addInternal(name, value);
            return this;
        }

        JsonObjectBuilder add(String name, Long value) {
            this.addInternal(name, value);
            return this;
        }

        private void addInternal(String name, Object value) {
            Preconditions.checkArgumentNotNull(name, Json.NAME);
            if (!this.isIgnored(value)) {
                this.properties.put(name, value);
            }
        }

        @Override
        boolean isEmpty() {
            if (this.properties.isEmpty()) {
                return true;
            }
            return this.isValuesEmpty(this.properties.values());
        }

        @Override
        String build() {
            StringBuilder builder = new StringBuilder();
            builder.append(Json.OBJECT_START);
            Iterator<Map.Entry<String, Object>> iterator = this.properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                Json.appendStringValue(builder, entry.getKey());
                builder.append(Json.NAME_VAL_SEPARATOR);
                Json.appendValue(builder, entry.getValue());
                if (!iterator.hasNext()) continue;
                builder.append(Json.ENTRY_SEPARATOR);
            }
            builder.append(Json.OBJECT_END);
            return builder.toString();
        }

        @Override
        protected JsonObjectBuilder self() {
            return this;
        }
    }

    static class JsonArrayBuilder
    extends JsonBuilder<JsonArrayBuilder> {
        private final List<Object> values = new ArrayList<Object>();

        private JsonArrayBuilder() {
        }

        JsonArrayBuilder add(JsonArrayBuilder value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(JsonObjectBuilder value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(String value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(Boolean value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(Integer value) {
            this.addInternal(value);
            return this;
        }

        JsonArrayBuilder add(Long value) {
            this.addInternal(value);
            return this;
        }

        private void addInternal(Object value) {
            if (!this.isIgnored(value)) {
                this.values.add(value);
            }
        }

        @Override
        boolean isEmpty() {
            return this.isValuesEmpty(this.values);
        }

        @Override
        String build() {
            StringBuilder builder = new StringBuilder();
            builder.append(Json.ARRAY_START);
            Iterator<Object> iterator = this.values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                Json.appendValue(builder, value);
                if (!iterator.hasNext()) continue;
                builder.append(Json.ENTRY_SEPARATOR);
            }
            builder.append(Json.ARRAY_END);
            return builder.toString();
        }

        @Override
        protected JsonArrayBuilder self() {
            return this;
        }
    }

    static abstract class JsonBuilder<T> {
        protected boolean ignoreEmptyBuilders = false;

        JsonBuilder() {
        }

        abstract boolean isEmpty();

        abstract String build();

        T setIgnoreEmptyBuilders(boolean value) {
            this.ignoreEmptyBuilders = value;
            return this.self();
        }

        protected boolean isIgnored(Object value) {
            return value == null || this.ignoreEmptyBuilders && value instanceof JsonBuilder && ((JsonBuilder)value).isEmpty();
        }

        protected boolean isValuesEmpty(Collection<Object> values) {
            if (values.isEmpty()) {
                return true;
            }
            for (Object object : values) {
                if (object instanceof JsonBuilder) {
                    if (((JsonBuilder)object).isEmpty()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        protected abstract T self();
    }
}

