/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.servlet.http.HttpServletRequest;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.experimental.Prioritized;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Formats;

class ProbeObserver
implements ObserverMethod<Object>,
Prioritized {
    private static final int PRIORITY_OFFSET = 100;
    private final Pattern excludePattern;
    private final List<EventInfo> events = Collections.synchronizedList(new ArrayList());
    private final CurrentEventMetadata currentEventMetadata;
    private final BeanManagerImpl manager;

    ProbeObserver(BeanManagerImpl manager, Pattern excludePattern) {
        this.currentEventMetadata = manager.getServices().get(CurrentEventMetadata.class);
        this.manager = manager;
        this.excludePattern = excludePattern;
    }

    @Override
    public Class<?> getBeanClass() {
        return ProbeExtension.class;
    }

    @Override
    public Type getObservedType() {
        return Object.class;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return Collections.emptySet();
    }

    @Override
    public Reception getReception() {
        return Reception.ALWAYS;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    @Override
    public void notify(Object event) {
        EventMetadata metadata = (EventMetadata)this.currentEventMetadata.peek();
        if (this.excludePattern != null && this.excludePattern.matcher(Formats.formatType(metadata.getType(), false)).matches()) {
            ProbeLogger.LOG.eventExcluded(metadata.getType());
            return;
        }
        boolean containerEvent = this.isContainerEvent(metadata.getQualifiers());
        List<ObserverMethod<?>> observers = this.resolveObservers(metadata, containerEvent);
        EventInfo info = new EventInfo(metadata.getType(), metadata.getQualifiers(), event, metadata.getInjectionPoint(), observers, containerEvent, System.currentTimeMillis());
        this.events.add(0, info);
    }

    private List<ObserverMethod<?>> resolveObservers(EventMetadata metadata, boolean containerEvent) {
        ArrayList observers = new ArrayList();
        ObserverNotifier notifier = containerEvent ? this.manager.getAccessibleLenientObserverNotifier() : this.manager.getGlobalLenientObserverNotifier();
        ResolvedObservers resolvedObservers = notifier.resolveObserverMethods(metadata.getType(), metadata.getQualifiers());
        for (ObserverMethod observer : resolvedObservers.getAllObservers()) {
            if (this.getBeanClass() == observer.getBeanClass()) continue;
            observers.add(observer);
        }
        return ImmutableList.copyOf(observers);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventInfo> getEvents() {
        List<EventInfo> list = this.events;
        synchronized (list) {
            return new ArrayList<EventInfo>(this.events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear() {
        List<EventInfo> list = this.events;
        synchronized (list) {
            int count = this.events.size();
            this.events.clear();
            return count;
        }
    }

    private boolean isContainerEvent(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (annotation.annotationType() != Initialized.class && annotation.annotationType() != Destroyed.class) continue;
            return true;
        }
        return false;
    }

    static class EventInfo {
        final boolean containerEvent;
        final Type type;
        final Set<Annotation> qualifiers;
        final String eventString;
        final InjectionPoint injectionPoint;
        final List<ObserverMethod<?>> observers;
        final long timestamp;

        private EventInfo(Type type, Set<Annotation> qualifiers, Object event, InjectionPoint injectionPoint, List<ObserverMethod<?>> observers, boolean containerEvent, long timestamp) {
            this.type = type;
            this.qualifiers = qualifiers;
            this.injectionPoint = injectionPoint;
            this.containerEvent = containerEvent;
            this.eventString = this.initEventString(event, containerEvent);
            this.observers = observers;
            this.timestamp = timestamp;
        }

        private String initEventString(Object event, boolean containerEvent) {
            if (containerEvent && event instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event;
                StringBuilder builder = new StringBuilder();
                builder.append(HttpServletRequest.class.getSimpleName());
                builder.append(' ');
                builder.append(request.getMethod());
                builder.append(' ');
                builder.append(request.getRequestURI());
                return builder.toString();
            }
            return event.toString();
        }
    }
}

