/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableSet;

public abstract class BeanAttributesBuilder<T, B> {
    protected String name;
    protected Set<Annotation> qualifiers = new HashSet<Annotation>();
    protected Class<? extends Annotation> scope;
    protected Set<Class<? extends Annotation>> stereotypes;
    protected Set<Type> types;
    protected boolean alternative;

    BeanAttributesBuilder() {
        this.qualifiers.add(AnyLiteral.INSTANCE);
        this.types = new HashSet<Type>();
        this.types.add((Type)((Object)Object.class));
        this.scope = Dependent.class;
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
        this.alternative = false;
    }

    public BeanAttributes<T> build() {
        return new ImmutableBeanAttributes(ImmutableSet.copyOf(this.stereotypes), this.alternative, this.name, ImmutableSet.copyOf(this.qualifiers), ImmutableSet.copyOf(this.types), this.scope);
    }

    public B addType(Type type) {
        this.types.add(type);
        return this.self();
    }

    public B types(Type ... types) {
        this.types = new HashSet<Type>();
        Collections.addAll(this.types, types);
        return this.self();
    }

    public B types(Set<Type> types) {
        this.types = new HashSet<Type>(types);
        return this.self();
    }

    public B scope(Class<? extends Annotation> scope) {
        Preconditions.checkArgumentNotNull(scope, "scope");
        this.scope = scope;
        return this.self();
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public B addQualifier(Annotation qualifier) {
        if (!qualifier.annotationType().equals(Default.class)) {
            this.qualifiers.remove(DefaultLiteral.INSTANCE);
        }
        this.qualifiers.add(qualifier);
        return this.self();
    }

    public B qualifiers(Annotation ... qualifiers) {
        this.qualifiers = new HashSet<Annotation>();
        Collections.addAll(this.qualifiers, qualifiers);
        return this.self();
    }

    public B qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers = new HashSet<Annotation>(qualifiers);
        return this.self();
    }

    public boolean hasQualifiers() {
        return !this.qualifiers.isEmpty();
    }

    public B addStereotype(Class<? extends Annotation> stereotype) {
        this.stereotypes.add(stereotype);
        return this.self();
    }

    public B stereotypes(Class<? extends Annotation> ... stereotypes) {
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
        Collections.addAll(this.stereotypes, stereotypes);
        return this.self();
    }

    public B stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes = new HashSet<Class<? extends Annotation>>(stereotypes);
        return this.self();
    }

    public B name(String name) {
        Preconditions.checkArgumentNotNull(name, "name");
        this.name = name;
        return this.self();
    }

    public B alternative() {
        return this.alternative(true);
    }

    public B alternative(boolean value) {
        this.alternative = value;
        return this.self();
    }

    protected abstract B self();
}

