/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.interceptor.InvocationContext;

public final class Invocation {
    private final Integer entryPointIdx;
    private final Bean<?> interceptedBean;
    private final String declaringClassName;
    private final long start;
    private final long duration;
    private final String methodName;
    private final List<Invocation> children;
    private final Type type;

    public Invocation(Integer entryPointIdx, Bean<?> interceptedBean, String declaringClassName, long start, long duration, String methodName, List<Invocation> children, Type type) {
        this.entryPointIdx = entryPointIdx;
        this.interceptedBean = interceptedBean;
        this.declaringClassName = declaringClassName;
        this.start = start;
        this.duration = duration;
        this.methodName = methodName;
        this.children = children;
        this.type = type;
    }

    public Integer getEntryPointIdx() {
        return this.entryPointIdx;
    }

    public boolean isEntryPoint() {
        return this.entryPointIdx != null;
    }

    public Bean<?> getInterceptedBean() {
        return this.interceptedBean;
    }

    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public String getBeanClass() {
        return this.interceptedBean != null ? this.interceptedBean.getBeanClass().getName() : this.declaringClassName;
    }

    public long getStart() {
        return this.start;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Invocation> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public Type getType() {
        return this.type;
    }

    static class Builder {
        private Integer entryPointIdx;
        private Bean<?> interceptedBean;
        private String declaringClassName;
        private long start;
        private long duration;
        private String methodName;
        private List<Builder> children;
        private Type type;
        private Builder parent;

        static Builder newBuilder(Integer idx) {
            return new Builder(idx);
        }

        Builder newChild() {
            Builder child = Builder.newBuilder(null);
            this.addChild(child);
            return child;
        }

        private Builder(Integer idx) {
            this.entryPointIdx = idx;
        }

        Builder setInterceptedBean(Bean<?> bean) {
            this.interceptedBean = bean;
            return this;
        }

        Builder setDeclaringClassName(String declaringClassName) {
            this.declaringClassName = declaringClassName;
            return this;
        }

        Builder setStart(long start) {
            this.start = start;
            return this;
        }

        Builder setDuration(long duration) {
            this.duration = duration;
            return this;
        }

        Builder setMethodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        Builder setType(Type type) {
            this.type = type;
            return this;
        }

        Builder guessType(InvocationContext ctx) {
            if (ctx.getMethod().isAnnotationPresent(Produces.class)) {
                return this.setType(Type.PRODUCER);
            }
            Annotation[][] parameterAnnotations = ctx.getMethod().getParameterAnnotations();
            if (parameterAnnotations.length > 0) {
                Annotation[][] annotationArray = parameterAnnotations;
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = annotationArray[i]) {
                        Class<? extends Annotation> type = annotation.annotationType();
                        if (Observes.class.equals(type)) {
                            return this.setType(Type.OBSERVER);
                        }
                        if (!Disposes.class.equals(type)) continue;
                        return this.setType(Type.DISPOSER);
                    }
                }
            }
            return this.setType(Type.BUSINESS);
        }

        Builder getParent() {
            return this.parent;
        }

        void setParent(Builder parent) {
            this.parent = parent;
        }

        boolean addChild(Builder child) {
            if (this.children == null) {
                this.children = new ArrayList<Builder>();
            }
            child.setParent(this);
            return this.children.add(child);
        }

        Invocation build() {
            ArrayList<Invocation> invocations = null;
            if (this.children != null) {
                invocations = new ArrayList<Invocation>(this.children.size());
                for (Builder builder : this.children) {
                    invocations.add(builder.build());
                }
            }
            return new Invocation(this.entryPointIdx, this.interceptedBean, this.declaringClassName, this.start, this.duration, this.methodName, invocations, this.type);
        }
    }

    static enum Comparators implements Comparator<Invocation>
    {
        ENTRY_POINT_IDX{

            @Override
            public int compare(Invocation o1, Invocation o2) {
                return o2.getEntryPointIdx().compareTo(o1.getEntryPointIdx());
            }
        }
        ,
        START{

            @Override
            public int compare(Invocation o1, Invocation o2) {
                return o1.getStart() < o2.getStart() ? 1 : (o1.getStart() == o2.getStart() ? 0 : -1);
            }
        }
        ,
        START_AND_DURATION{

            @Override
            public int compare(Invocation o1, Invocation o2) {
                if (o1.getStart() == o2.getStart()) {
                    return o1.getDuration() < o2.getDuration() ? 1 : (o1.getDuration() == o2.getDuration() ? 0 : -1);
                }
                return o1.getStart() < o2.getStart() ? 1 : (o1.getStart() == o2.getStart() ? 0 : -1);
            }
        };


        @Override
        public abstract int compare(Invocation var1, Invocation var2);
    }

    public static enum Type {
        BUSINESS,
        PRODUCER,
        DISPOSER,
        OBSERVER;

    }
}

