/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.net.URL;
import java.util.Map;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.util.Preconditions;

public interface BeanArchiveScanner {
    public Map<URL, ScanResult> scan();

    public static class ScanResult {
        private final String beanArchiveRef;
        private final BeansXml beansXml;
        private String beanArchiveId;

        public ScanResult(BeansXml beansXml, String beanArchiveRef, String beanArchiveId) {
            this.beansXml = beansXml;
            this.beanArchiveRef = beanArchiveRef;
            this.beanArchiveId = beanArchiveId;
        }

        public ScanResult(BeansXml beansXml, String beanArchiveRef) {
            this(beansXml, beanArchiveRef, null);
        }

        public String getBeanArchiveRef() {
            return this.beanArchiveRef;
        }

        public BeansXml getBeansXml() {
            return this.beansXml;
        }

        public String getBeanArchiveId() {
            return this.beanArchiveId != null ? this.beanArchiveId : this.beanArchiveRef;
        }

        public ScanResult extractBeanArchiveId(String separator) {
            Preconditions.checkArgumentNotNull(separator, "separator");
            if (this.beanArchiveRef.contains(separator)) {
                this.beanArchiveId = this.beanArchiveRef.substring(this.beanArchiveRef.indexOf(separator), this.beanArchiveRef.length());
            }
            return this;
        }
    }
}

