/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.weld.executor.AbstractManagedExecutorServices;
import org.jboss.weld.executor.DaemonThreadFactory;
import org.jboss.weld.logging.BootstrapLogger;

public class FixedThreadPoolExecutorServices
extends AbstractManagedExecutorServices {
    private final int threadPoolSize;
    private final ExecutorService executor;

    public FixedThreadPoolExecutorServices(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        this.executor = Executors.newFixedThreadPool(threadPoolSize, new DaemonThreadFactory(new ThreadGroup("weld-workers"), "weld-worker-"));
        BootstrapLogger.LOG.threadsInUse(threadPoolSize);
    }

    @Override
    public ExecutorService getTaskExecutor() {
        return this.executor;
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String toString() {
        return "FixedThreadPoolExecutorServices [threadPoolSize=" + this.threadPoolSize + "]";
    }
}

