/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.collections.SetMultimap;

public class Probe
implements Service {
    private static final int DEFAULT_INVOCATIONS_LIMIT = 5000;
    private volatile Mappings mappings;
    private final ConcurrentMap<Integer, Invocation> invocations = new ConcurrentHashMap<Integer, Invocation>();
    private final Comparator<Bean<?>> beanComparator = new Comparator<Bean<?>>(){

        @Override
        public int compare(Bean<?> o1, Bean<?> o2) {
            if (o1.getBeanClass().equals(o2.getBeanClass())) {
                return Probe.this.mappings.getBeanToId().get(o1).compareTo(Probe.this.mappings.getBeanToId().get(o2));
            }
            return o1.getBeanClass().getName().compareTo(o2.getBeanClass().getName());
        }
    };
    private final Comparator<ObserverMethod<?>> observerComparator = new Comparator<ObserverMethod<?>>(){

        @Override
        public int compare(ObserverMethod<?> o1, ObserverMethod<?> o2) {
            if (o1.getBeanClass().equals(o2.getBeanClass())) {
                return Probe.this.mappings.getObserverToId().get(o1).compareTo(Probe.this.mappings.getObserverToId().get(o2));
            }
            return o1.getBeanClass().getName().compareTo(o2.getBeanClass().getName());
        }
    };
    private final Comparator<BeanDeploymentArchive> bdaComparator = new Comparator<BeanDeploymentArchive>(){

        @Override
        public int compare(BeanDeploymentArchive bda1, BeanDeploymentArchive bda2) {
            int result = Boolean.compare(bda2.getId().contains("WEB-INF/classes"), bda1.getId().contains("WEB-INF/classes"));
            if (result == 0 && (result = Boolean.compare(bda1.getId().endsWith(".additionalClasses"), bda2.getId().endsWith(".additionalClasses"))) == 0) {
                result = Components.getNumberOfEnabledBeans(Probe.this.mappings.getBdaToManager().get(bda2)).compareTo(Components.getNumberOfEnabledBeans(Probe.this.mappings.getBdaToManager().get(bda1)));
            }
            return result == 0 ? bda1.getId().compareTo(bda2.getId()) : result;
        }
    };

    public void initialize(BeanManagerImpl beanManager) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Probe already initialized!");
        }
        this.mappings = new Mappings(beanManager);
    }

    public boolean isInitialized() {
        return this.mappings != null;
    }

    List<Bean<?>> getBeans() {
        this.checkInitialized();
        ArrayList data = new ArrayList(this.mappings.getIdToBean().values());
        Collections.sort(data, this.beanComparator);
        return data;
    }

    String getBeanId(Bean<?> bean) {
        this.checkInitialized();
        return this.mappings.getBeanToId().get(bean);
    }

    Bean<?> getBean(String id) {
        this.checkInitialized();
        return this.mappings.getIdToBean().get(id);
    }

    BeanManagerImpl getBeanManager(Bean<?> bean) {
        this.checkInitialized();
        return this.mappings.getBeanToManager().get(bean);
    }

    List<ObserverMethod<?>> getObservers() {
        this.checkInitialized();
        ArrayList data = new ArrayList(this.mappings.getIdToObserver().values());
        Collections.sort(data, this.observerComparator);
        return data;
    }

    String getObserverId(ObserverMethod<?> observerMethod) {
        this.checkInitialized();
        return this.mappings.getObserverToId().get(observerMethod);
    }

    ObserverMethod<?> getObserver(String id) {
        this.checkInitialized();
        return this.mappings.getIdToObserver().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInvocation(Invocation invocation) {
        this.checkInitialized();
        if (!invocation.isEntryPoint()) {
            throw new IllegalStateException("Invocation is not an entry point!");
        }
        if (this.invocations.size() > 5000) {
            Probe probe = this;
            synchronized (probe) {
                if (this.invocations.size() > 5000) {
                    Set keySet = this.invocations.keySet();
                    ArrayList sorted = new ArrayList(keySet);
                    Collections.sort(sorted, Collections.reverseOrder());
                    if (keySet.removeAll(sorted.subList(2500, sorted.size()))) {
                        ProbeLogger.LOG.monitoringLimitExceeded(Invocation.class.getSimpleName(), 5000);
                    }
                }
            }
        }
        this.invocations.put(invocation.getEntryPointIdx(), invocation);
    }

    List<Invocation> getInvocations() {
        this.checkInitialized();
        ArrayList<Invocation> sorted = new ArrayList<Invocation>(this.invocations.values());
        Collections.sort(sorted, Invocation.Comparators.ENTRY_POINT_IDX);
        return sorted;
    }

    Invocation getInvocation(String id) {
        this.checkInitialized();
        try {
            return (Invocation)this.invocations.get(Integer.valueOf(id));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    int clearInvocations() {
        this.checkInitialized();
        int size = this.invocations.size();
        this.invocations.clear();
        return size;
    }

    Comparator<BeanDeploymentArchive> getBdaComparator() {
        return this.bdaComparator;
    }

    Set<AbstractProducerBean<?, ?, ?>> getDeclaredProducers(Bean<?> bean) {
        return this.mappings.getBeanToDeclaredProducers().containsKey(bean) ? (Set)this.mappings.getBeanToDeclaredProducers().get(bean) : Collections.emptySet();
    }

    @Override
    public void cleanup() {
        if (this.mappings != null) {
            this.mappings.clear();
        }
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw ProbeLogger.LOG.probeNotInitialized();
        }
    }

    private static class Mappings {
        private final Map<Bean<?>, String> beanToId = new HashMap();
        private final Map<String, Bean<?>> idToBean = new HashMap();
        private final Map<Bean<?>, BeanManagerImpl> beanToManager = new HashMap();
        private final Map<String, ObserverMethod<?>> idToObserver = new HashMap();
        private final Map<ObserverMethod<?>, String> observerToId = new HashMap();
        private final Map<BeanDeploymentArchive, BeanManagerImpl> bdaToManager;
        private final SetMultimap<Bean<?>, AbstractProducerBean<?, ?, ?>> beanToDeclaredProducers = SetMultimap.newSetMultimap();

        Mappings(BeanManagerImpl beanManager) {
            ContextualStore contextualStore = beanManager.getServices().get(ContextualStore.class);
            this.bdaToManager = Container.instance(beanManager).beanDeploymentArchives();
            for (Map.Entry<BeanDeploymentArchive, BeanManagerImpl> entry : this.bdaToManager.entrySet()) {
                ProbeLogger.LOG.processingBeanDeploymentArchive(entry.getKey().getId());
                BeanManagerImpl manager = entry.getValue();
                for (Bean<?> bean : manager.getBeans()) {
                    if (bean instanceof ExtensionBean) {
                        ExtensionBean extensionBean = (ExtensionBean)bean;
                        if (this.idToBean.containsValue(extensionBean)) continue;
                        this.putBean(Components.getId(extensionBean.getIdentifier()), manager, extensionBean);
                        continue;
                    }
                    if (bean instanceof AbstractBuiltInBean) {
                        String id = Components.getBuiltinBeanId((AbstractBuiltInBean)bean);
                        if (this.idToBean.containsKey(id)) continue;
                        this.putBean(id, bean);
                        continue;
                    }
                    if (!manager.isBeanEnabled(bean)) continue;
                    this.putBean(contextualStore, manager, bean);
                }
                for (Interceptor interceptor : manager.getInterceptors()) {
                    this.putBean(contextualStore, manager, interceptor);
                }
                for (Decorator decorator : manager.getDecorators()) {
                    this.putBean(contextualStore, manager, decorator);
                }
                int customObservers = 0;
                for (ObserverMethod<?> observerMethod : manager.getObservers()) {
                    if (observerMethod instanceof ObserverMethodImpl) {
                        ObserverMethodImpl observerMethodImpl = (ObserverMethodImpl)observerMethod;
                        this.putObserver(Components.getId(observerMethodImpl.getId()), observerMethodImpl);
                        continue;
                    }
                    this.putObserver(Components.getId("" + customObservers++), observerMethod);
                }
            }
            for (Bean bean : this.idToBean.values()) {
                Components.BeanKind kind = Components.BeanKind.from(bean);
                if (!Components.BeanKind.PRODUCER_FIELD.equals((Object)kind) && !Components.BeanKind.PRODUCER_METHOD.equals((Object)kind) && !Components.BeanKind.RESOURCE.equals((Object)kind) || !(bean instanceof AbstractProducerBean)) continue;
                AbstractProducerBean producerBean = (AbstractProducerBean)bean;
                this.beanToDeclaredProducers.put(producerBean.getDeclaringBean(), (Object)producerBean);
            }
        }

        Map<Bean<?>, String> getBeanToId() {
            return this.beanToId;
        }

        Map<String, Bean<?>> getIdToBean() {
            return this.idToBean;
        }

        Map<Bean<?>, BeanManagerImpl> getBeanToManager() {
            return this.beanToManager;
        }

        Map<String, ObserverMethod<?>> getIdToObserver() {
            return this.idToObserver;
        }

        Map<ObserverMethod<?>, String> getObserverToId() {
            return this.observerToId;
        }

        Map<BeanDeploymentArchive, BeanManagerImpl> getBdaToManager() {
            return this.bdaToManager;
        }

        SetMultimap<Bean<?>, AbstractProducerBean<?, ?, ?>> getBeanToDeclaredProducers() {
            return this.beanToDeclaredProducers;
        }

        private void putBean(ContextualStore contextualStore, Bean<?> bean) {
            this.putBean(Components.getId(contextualStore.putIfAbsent(bean)), bean);
        }

        private void putBean(String id, Bean<?> bean) {
            this.idToBean.put(id, bean);
            this.beanToId.put(bean, id);
        }

        private void putBean(String id, BeanManagerImpl manager, Bean<?> bean) {
            this.putBean(id, bean);
            this.beanToManager.put(bean, manager);
        }

        private void putBean(ContextualStore contextualStore, BeanManagerImpl manager, Bean<?> bean) {
            this.putBean(contextualStore, bean);
            this.beanToManager.put(bean, manager);
        }

        private void putObserver(String id, ObserverMethod<?> observerMethod) {
            this.idToObserver.put(id, observerMethod);
            this.observerToId.put(observerMethod, id);
        }

        void clear() {
            this.idToBean.clear();
            this.beanToId.clear();
            this.beanToManager.clear();
            this.idToObserver.clear();
            this.observerToId.clear();
        }
    }
}

