/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.Components;
import org.jboss.weld.probe.IOUtils;
import org.jboss.weld.probe.Invocation;
import org.jboss.weld.probe.Json;
import org.jboss.weld.probe.JsonObjects;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.probe.ProbeObserver;
import org.jboss.weld.probe.Queries;

enum Resource {
    DEPLOYMENT("/deployment", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().append(JsonObjects.createDeploymentJson(beanManager, probe));
        }
    }),
    BEANS("/beans", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Representation representation = Representation.from(req.getParameter("representation"));
            if (representation == null) {
                representation = Representation.BASIC;
            }
            resp.getWriter().append(JsonObjects.createBeansJson(Queries.find(probe.getBeans(), this.getPage(req), this.getPageSize(req), this.initFilters(req, new Queries.BeanFilters(probe))), probe, beanManager, representation));
        }
    }),
    BEAN("/beans/{.+}", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Bean<?> bean = probe.getBean(pathInfoParts[1]);
            if (bean != null) {
                resp.getWriter().append(JsonObjects.createFullBeanJson(bean, Boolean.valueOf(req.getParameter("transientDependencies")), Boolean.valueOf(req.getParameter("transientDependents")), beanManager, probe));
            } else {
                resp.sendError(404);
            }
        }
    }),
    BEAN_INSTANCE("/beans/{.+}/instance", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Bean<?> bean = probe.getBean(pathInfoParts[1]);
            if (bean != null && Components.isInspectableScope(bean.getScope())) {
                Object instance = Components.findContextualInstance(bean, beanManager);
                if (instance != null) {
                    resp.getWriter().append(JsonObjects.createContextualInstanceJson(bean, instance, probe));
                } else {
                    resp.sendError(404);
                }
            } else {
                resp.sendError(404);
            }
        }
    }),
    OBSERVERS("/observers", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().append(JsonObjects.createObserversJson(Queries.find(probe.getObservers(), this.getPage(req), this.getPageSize(req), this.initFilters(req, new Queries.ObserverFilters(probe))), probe));
        }
    }),
    OBSERVER("/observers/{.+}", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ObserverMethod<?> observer = probe.getObserver(pathInfoParts[1]);
            if (observer != null) {
                resp.getWriter().append(JsonObjects.createFullObserverJson(observer, probe));
            } else {
                resp.sendError(404);
            }
        }
    }),
    CONTEXTS("/contexts", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().append(JsonObjects.createContextsJson(beanManager, probe).build());
        }
    }),
    CONTEXT("/contexts/{[a-zA-Z_0]+}", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            String id = pathInfoParts[1];
            Class<? extends Annotation> scope = Components.INSPECTABLE_SCOPES.get(id);
            if (scope != null) {
                resp.getWriter().append(JsonObjects.createContextJson(id, scope, beanManager, probe, req).build());
            } else {
                resp.sendError(404);
            }
        }
    }),
    INVOCATIONS("/invocations", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().append(JsonObjects.createInvocationsJson(Queries.find(probe.getInvocations(), this.getPage(req), this.getPageSize(req), this.initFilters(req, new Queries.InvocationsFilters(probe))), probe));
        }

        @Override
        protected void handleDelete(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().append(Json.objectBuilder().add("removedInvocations", probe.clearInvocations()).build());
        }
    }),
    INVOCATION("/invocations/{.+}", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Invocation entryPoint = probe.getInvocation(pathInfoParts[1]);
            if (entryPoint != null) {
                resp.getWriter().append(JsonObjects.createFullInvocationJson(entryPoint, probe).build());
            } else {
                resp.sendError(404);
            }
        }
    }),
    EVENTS("/events", new Handler(){

        @Override
        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ProbeObserver observer = beanManager.getExtension(ProbeExtension.class).getProbeObserver();
            resp.getWriter().append(JsonObjects.createEventsJson(Queries.find(observer.getEvents(), this.getPage(req), this.getPageSize(req), this.initFilters(req, new Queries.EventsFilters(probe))), probe));
        }

        @Override
        protected void handleDelete(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            ProbeObserver observer = beanManager.getExtension(ProbeExtension.class).getProbeObserver();
            resp.getWriter().append(Json.objectBuilder().add("removedEvents", observer.clear()).build());
        }
    }),
    CLIENT_RESOURCE("/client/{[a-zA-Z_0-9-]+\\.\\w+}", new Handler(){

        @Override
        protected void handle(BeanManagerImpl beanManager, Probe probe, HttpMethod method, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            if (!HttpMethod.GET.equals((Object)method)) {
                resp.sendError(405);
                return;
            }
            String resourceName = "/META-INF/client/" + (pathInfoParts == null ? "probe.html" : pathInfoParts[pathInfoParts.length - 1]);
            String contentType = Resource.detectContentType(resourceName);
            12.setHeaders(resp, contentType);
            if (Resource.isCachableContentType(contentType)) {
                resp.setHeader("Cache-Control", "max-age=86400");
            }
            if (Resource.isTextBasedContenType(contentType)) {
                String content = IOUtils.getResourceAsString(resourceName);
                if (content == null) {
                    resp.sendError(404);
                }
                content = content.replace("${contextPath}", req.getContextPath() + req.getServletPath() + "/");
                resp.getWriter().append(content);
            } else if (!IOUtils.writeResource(resourceName, (OutputStream)resp.getOutputStream())) {
                resp.sendError(404);
            }
        }
    });

    private final String[] parts;
    private final Handler handler;

    private Resource(String path, Handler handler) {
        this.parts = Resource.splitPath(path);
        this.handler = handler;
    }

    protected void handle(BeanManagerImpl beanManager, Probe probe, HttpMethod method, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.handler.handle(beanManager, probe, method, pathInfoParts, req, resp);
    }

    boolean matches(String[] pathInfo) {
        if (pathInfo.length != this.parts.length) {
            return false;
        }
        for (int i = 0; i < this.parts.length; ++i) {
            if (!(Resource.isParam(this.parts[i]) ? !pathInfo[i].matches(this.parts[i].substring(1, this.parts[i].length() - 1)) : !this.parts[i].equals(pathInfo[i]))) continue;
            return false;
        }
        return true;
    }

    String[] getParts() {
        return this.parts;
    }

    static boolean isParam(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    static String[] splitPath(String path) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder builder = null;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (builder == null) continue;
                parts.add(builder.toString());
                builder = null;
                continue;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(c);
        }
        if (builder != null) {
            parts.add(builder.toString());
        }
        return parts.isEmpty() ? null : parts.toArray(new String[parts.size()]);
    }

    static String detectContentType(String resourceName) {
        if (resourceName.endsWith("html")) {
            return "text/html";
        }
        if (resourceName.endsWith("css")) {
            return "text/css";
        }
        if (resourceName.endsWith("js")) {
            return "text/javascript";
        }
        if (resourceName.endsWith("png")) {
            return "image/png";
        }
        if (resourceName.endsWith("ttf") || resourceName.endsWith("otf")) {
            return "application/font-sfnt";
        }
        if (resourceName.endsWith("eot")) {
            return "application/vnd.ms-fontobject";
        }
        if (resourceName.endsWith("woff")) {
            return "application/font-woff";
        }
        if (resourceName.endsWith("svg")) {
            return "image/svg+xml";
        }
        if (resourceName.endsWith("ico")) {
            return " image/x-icon";
        }
        return "text/plain";
    }

    static boolean isCachableContentType(String contentType) {
        return "text/css".equals(contentType) || "text/javascript".equals(contentType) || " image/x-icon".equals(contentType) || "image/png".equals(contentType) || "image/svg+xml".equals(contentType);
    }

    static boolean isTextBasedContenType(String contentType) {
        return !"image/png".equals(contentType) && !" image/x-icon".equals(contentType) && !"application/font-sfnt".equals(contentType) && !"application/font-woff".equals(contentType) && !"application/vnd.ms-fontobject".equals(contentType);
    }

    static enum Representation {
        SIMPLE,
        BASIC,
        FULL;


        static Representation from(String value) {
            for (Representation representation : Representation.values()) {
                if (!representation.toString().equalsIgnoreCase(value)) continue;
                return representation;
            }
            return null;
        }
    }

    static enum HttpMethod {
        GET,
        POST,
        DELETE,
        OPTIONS;

    }

    static abstract class Handler {
        Handler() {
        }

        protected void handle(BeanManagerImpl beanManager, Probe probe, HttpMethod method, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            Handler.setHeaders(resp, this.getContentType());
            switch (method) {
                case GET: {
                    this.handleGet(beanManager, probe, pathInfoParts, req, resp);
                    break;
                }
                case POST: {
                    this.handlePost(beanManager, probe, pathInfoParts, req, resp);
                    break;
                }
                case DELETE: {
                    this.handleDelete(beanManager, probe, pathInfoParts, req, resp);
                    break;
                }
                default: {
                    resp.sendError(405);
                }
            }
        }

        protected void handleGet(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected void handlePost(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected void handleDelete(BeanManagerImpl beanManager, Probe probe, String[] pathInfoParts, HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.sendError(405);
        }

        protected int getPage(HttpServletRequest req) {
            String pageParam = req.getParameter("page");
            if (pageParam == null) {
                return 1;
            }
            try {
                return Integer.valueOf(pageParam);
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }

        protected int getPageSize(HttpServletRequest req) {
            String pageSizeParam = req.getParameter("pageSize");
            if (pageSizeParam == null) {
                return 50;
            }
            try {
                int result = Integer.valueOf(pageSizeParam);
                return result > 0 ? result : 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        protected <E, T extends Queries.Filters<E>> T initFilters(HttpServletRequest req, T filters) {
            String filtersParam = req.getParameter("filters");
            if (filtersParam == null || filtersParam.trim().length() == 0) {
                return null;
            }
            filters.processFilters(filtersParam);
            return filters;
        }

        protected String getContentType() {
            return "application/json";
        }

        static void setHeaders(HttpServletResponse resp, String contentType) {
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType(contentType);
            Handler.setCorsHeaders(resp);
        }

        static void setCorsHeaders(HttpServletResponse resp) {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            resp.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE");
        }
    }
}

