/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.interceptor.InterceptorBinding;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.InterceptorBindingSet;
import org.jboss.weld.util.collections.Multimap;
import org.jboss.weld.util.collections.SetMultimap;

public class Interceptors {
    private Interceptors() {
    }

    public static Set<Annotation> filterInterceptorBindings(BeanManagerImpl beanManager, Collection<Annotation> annotations) {
        InterceptorBindingSet interceptorBindings = new InterceptorBindingSet(beanManager);
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            interceptorBindings.add(annotation);
        }
        return interceptorBindings;
    }

    public static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl beanManager, Collection<Annotation> annotations, boolean addTopLevelInterceptorBindings, boolean addInheritedInterceptorBindings) {
        InterceptorBindingSet flattenInterceptorBindings = new InterceptorBindingSet(beanManager);
        if (addTopLevelInterceptorBindings) {
            for (Annotation annotation : annotations) {
                boolean added = flattenInterceptorBindings.add(annotation);
                if (added) continue;
                throw BeanManagerLogger.LOG.duplicateInterceptorBinding(annotations);
            }
        }
        if (addInheritedInterceptorBindings) {
            for (Annotation annotation : annotations) {
                Interceptors.addInheritedInterceptorBindings(annotation.annotationType(), beanManager.getServices().get(MetaAnnotationStore.class), flattenInterceptorBindings);
            }
        }
        return flattenInterceptorBindings;
    }

    private static void addInheritedInterceptorBindings(Class<? extends Annotation> bindingType, MetaAnnotationStore store, Set<Annotation> inheritedBindings) {
        Set<Annotation> metaBindings = store.getInterceptorBindingModel(bindingType).getInheritedInterceptionBindingTypes();
        inheritedBindings.addAll(metaBindings);
        for (Annotation metaBinding : metaBindings) {
            Interceptors.addInheritedInterceptorBindings(metaBinding.annotationType(), store, inheritedBindings);
        }
    }

    public static Multimap<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, EnhancedAnnotatedType<?> clazz, Collection<Class<? extends Annotation>> stereotypes) {
        Set<Annotation> rawBindings = clazz.getMetaAnnotations(InterceptorBinding.class);
        Set<Annotation> classBindingAnnotations = Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, rawBindings), true, false);
        HashSet<Annotation> inheritedBindingAnnotations = new HashSet<Annotation>();
        inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, rawBindings), false, true));
        for (Class<? extends Annotation> annotation : stereotypes) {
            inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, beanManager.getStereotypeDefinition(annotation)), true, true));
        }
        return Interceptors.mergeBeanInterceptorBindings(beanManager, clazz, classBindingAnnotations, inheritedBindingAnnotations);
    }

    public static Multimap<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, AnnotatedType<?> clazz, Collection<Annotation> classBindingAnnotations, Collection<Annotation> inheritedBindingAnnotations) {
        SetMultimap<Class<? extends Annotation>, Annotation> mergedBeanBindings = SetMultimap.newSetMultimap();
        HashSet<Annotation> acceptedInheritedBindings = new HashSet<Annotation>();
        for (Annotation bindingAnnotation : classBindingAnnotations) {
            mergedBeanBindings.put(bindingAnnotation.annotationType(), bindingAnnotation);
        }
        for (Annotation bindingAnnotation : inheritedBindingAnnotations) {
            Class<? extends Annotation> bindingAnnotationType = bindingAnnotation.annotationType();
            if (mergedBeanBindings.containsKey(bindingAnnotationType)) continue;
            acceptedInheritedBindings.add(bindingAnnotation);
        }
        for (Annotation bindingAnnotation : acceptedInheritedBindings) {
            mergedBeanBindings.put(bindingAnnotation.annotationType(), bindingAnnotation);
        }
        return mergedBeanBindings;
    }
}

