/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Unmanaged;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractCDI<T>
extends CDI<T>
implements WeldInstance<T> {
    protected final Set<String> knownClassNames;
    private final ComputingCache<BeanManagerImpl, WeldInstance<T>> instanceCache;

    public AbstractCDI() {
        ImmutableSet.Builder<String> names = ImmutableSet.builder();
        for (Class<?> clazz = this.getClass(); clazz != CDI.class; clazz = clazz.getSuperclass()) {
            names.add(clazz.getName());
        }
        names.add(Unmanaged.class.getName());
        this.knownClassNames = names.build();
        this.instanceCache = ComputingCacheBuilder.newBuilder().build(b -> (WeldInstance)Reflections.cast(b.getInstance(b.createCreationalContext((Contextual)null))));
    }

    @Override
    public Iterator<T> iterator() {
        return this.instanceInternal().iterator();
    }

    @Override
    public T get() {
        return this.instanceInternal().get();
    }

    @Override
    public WeldInstance<T> select(Annotation ... qualifiers) {
        return this.instanceInternal().select(qualifiers);
    }

    @Override
    public <U extends T> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        return this.instanceInternal().select((Class)subtype, qualifiers);
    }

    @Override
    public <U extends T> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        return this.instanceInternal().select((TypeLiteral)subtype, qualifiers);
    }

    @Override
    public boolean isUnsatisfied() {
        return this.instanceInternal().isUnsatisfied();
    }

    @Override
    public boolean isAmbiguous() {
        return this.instanceInternal().isAmbiguous();
    }

    @Override
    public void destroy(T instance) {
        this.instanceInternal().destroy(instance);
    }

    @Override
    public WeldInstance.Handler<T> getHandler() {
        return this.getInstance().getHandler();
    }

    @Override
    public boolean isResolvable() {
        return this.getInstance().isResolvable();
    }

    @Override
    public Iterable<WeldInstance.Handler<T>> handlers() {
        return this.getInstance().handlers();
    }

    protected String getCallingClassName() {
        boolean outerSubclassReached = false;
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!this.knownClassNames.contains(element.getClassName())) {
                if (!outerSubclassReached) continue;
                return element.getClassName();
            }
            outerSubclassReached = true;
        }
        throw BeanManagerLogger.LOG.unableToIdentifyBeanManager();
    }

    private WeldInstance<T> instanceInternal() {
        this.checkState();
        return this.getInstance();
    }

    protected WeldInstance<T> getInstance() {
        return this.instanceCache.getValue(BeanManagerProxy.unwrap(this.getBeanManager()));
    }

    protected void checkState() {
    }
}

