/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Named;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class BeanAttributesConfiguratorImpl<T>
implements BeanAttributesConfigurator<T>,
Configurator<BeanAttributes<T>> {
    static final Set<Annotation> DEFAULT_QUALIFIERS = ImmutableSet.of(new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE});
    private String name;
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Class<? extends Annotation> scope;
    private final Set<Class<? extends Annotation>> stereotypes;
    private Set<Type> types = new HashSet<Type>();
    private boolean isAlternative;

    public BeanAttributesConfiguratorImpl() {
        this.types.add((Type)((Object)Object.class));
        this.stereotypes = new HashSet<Class<? extends Annotation>>();
    }

    public BeanAttributesConfiguratorImpl(BeanAttributes<T> beanAttributes) {
        this();
        this.read(beanAttributes);
    }

    @Override
    public <U extends T> BeanAttributesConfigurator<U> read(AnnotatedType<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <U extends T> BeanAttributesConfigurator<U> read(AnnotatedMember<U> member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BeanAttributesConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        this.name(beanAttributes.getName());
        this.qualifiers(beanAttributes.getQualifiers());
        this.scope(beanAttributes.getScope());
        this.stereotypes(beanAttributes.getStereotypes());
        this.types(beanAttributes.getTypes());
        this.alternative(beanAttributes.isAlternative());
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addType(Type type) {
        this.types.add(type);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        this.types.add(typeLiteral.getType());
        return null;
    }

    @Override
    public BeanAttributesConfigurator<T> addTypes(Type ... types) {
        Collections.addAll(this.types, types);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addTypes(Set<Type> types) {
        this.types.addAll(types);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addTransitiveTypeClosure(Type type) {
        this.types.addAll(Beans.getLegalBeanTypes(new HierarchyDiscovery(type).getTypeClosure(), type, new Type[0]));
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> types(Type ... types) {
        this.types.clear();
        return this.addTypes(types);
    }

    @Override
    public BeanAttributesConfigurator<T> types(Set<Type> types) {
        this.types.clear();
        return this.addTypes(types);
    }

    @Override
    public BeanAttributesConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addQualifier(Annotation qualifier) {
        this.removeDefaultQualifierIfNeeded(qualifier);
        this.qualifiers.add(qualifier);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        Collections.addAll(this.qualifiers, qualifiers);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            this.removeDefaultQualifierIfNeeded(annotation);
        }
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    @Override
    public BeanAttributesConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        return this.addQualifiers(qualifiers);
    }

    @Override
    public BeanAttributesConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        this.stereotypes.add(stereotype);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.addAll(stereotypes);
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.stereotypes.clear();
        return this.addStereotypes(stereotypes);
    }

    @Override
    public BeanAttributesConfigurator<T> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public BeanAttributesConfigurator<T> alternative(boolean alternative) {
        this.isAlternative = alternative;
        return this;
    }

    @Override
    public BeanAttributes<T> complete() {
        return new ImmutableBeanAttributes(ImmutableSet.copyOf(this.stereotypes), this.isAlternative, this.name, this.initQualifiers(this.qualifiers), ImmutableSet.copyOf(this.types), this.initScope());
    }

    private void removeDefaultQualifierIfNeeded(Annotation qualifier) {
        if (!qualifier.annotationType().equals(Named.class)) {
            this.qualifiers.remove(Default.Literal.INSTANCE);
        }
    }

    private Class<? extends Annotation> initScope() {
        return this.scope != null ? this.scope : Dependent.class;
    }

    private Set<Annotation> initQualifiers(Set<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return DEFAULT_QUALIFIERS;
        }
        Set<Annotation> normalized = new HashSet<Annotation>(qualifiers);
        normalized.remove(Any.Literal.INSTANCE);
        normalized.remove(Default.Literal.INSTANCE);
        if (normalized.isEmpty()) {
            normalized = DEFAULT_QUALIFIERS;
        } else {
            ImmutableSet.Builder<Annotation> builder = ImmutableSet.builder();
            if (normalized.size() == 1 && qualifiers.iterator().next().annotationType().equals(Named.class)) {
                builder.add(Default.Literal.INSTANCE);
            }
            builder.add(Any.Literal.INSTANCE);
            builder.addAll((Iterable<Annotation>)qualifiers);
            normalized = builder.build();
        }
        return normalized;
    }
}

