/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.configurator.BeanConfigurator;
import javax.enterprise.util.TypeLiteral;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bootstrap.BeanDeploymentFinder;
import org.jboss.weld.bootstrap.events.configurator.BeanAttributesConfiguratorImpl;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.bean.ForwardingBeanAttributes;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class BeanConfiguratorImpl<T>
implements BeanConfigurator<T>,
Configurator<Bean<T>> {
    private BeanManagerImpl beanManager;
    private Class<?> beanClass;
    private final Set<InjectionPoint> injectionPoints;
    private final BeanAttributesConfiguratorImpl<T> attributes;
    private String id;
    private CreateCallback<T> createCallback;
    private DestroyCallback<T> destroyCallback;

    public BeanConfiguratorImpl(Class<?> defaultBeanClass, BeanDeploymentFinder beanDeploymentFinder) {
        this.beanClass = defaultBeanClass;
        this.injectionPoints = new HashSet<InjectionPoint>();
        this.attributes = new BeanAttributesConfiguratorImpl();
        this.initBeanManager(beanDeploymentFinder);
    }

    @Override
    public BeanConfigurator<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    @Override
    public BeanConfigurator<T> addInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoints.add(injectionPoint);
        return this;
    }

    @Override
    public BeanConfigurator<T> addInjectionPoints(InjectionPoint ... injectionPoints) {
        Collections.addAll(this.injectionPoints, injectionPoints);
        return this;
    }

    @Override
    public BeanConfigurator<T> addInjectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints.addAll(injectionPoints);
        return this;
    }

    @Override
    public BeanConfigurator<T> injectionPoints(InjectionPoint ... injectionPoints) {
        this.injectionPoints.clear();
        return this.addInjectionPoints(injectionPoints);
    }

    @Override
    public BeanConfigurator<T> injectionPoints(Set<InjectionPoint> injectionPoints) {
        this.injectionPoints.clear();
        return this.addInjectionPoints(injectionPoints);
    }

    @Override
    public BeanConfigurator<T> id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public <U extends T> BeanConfigurator<U> createWith(Function<CreationalContext<U>, U> callback) {
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromCreateWith(callback));
        return (BeanConfigurator)Reflections.cast(this);
    }

    @Override
    public <U extends T> BeanConfigurator<U> produceWith(Function<Instance<Object>, U> callback) {
        this.createCallback = (CreateCallback)Reflections.cast(CreateCallback.fromProduceWith(callback));
        return (BeanConfigurator)Reflections.cast(this);
    }

    @Override
    public BeanConfigurator<T> destroyWith(BiConsumer<T, CreationalContext<T>> callback) {
        this.destroyCallback = DestroyCallback.fromDestroy(callback);
        return this;
    }

    @Override
    public BeanConfigurator<T> disposeWith(BiConsumer<T, Instance<Object>> callback) {
        this.destroyCallback = DestroyCallback.fromDispose(callback);
        return this;
    }

    @Override
    public <U extends T> BeanConfigurator<U> read(AnnotatedType<U> type) {
        if (this.beanManager == null) {
            throw new IllegalStateException();
        }
        InjectionTarget injectionTarget = (InjectionTarget)Reflections.cast(this.beanManager.getInjectionTargetFactory(type).createInjectionTarget((Bean)null));
        this.addInjectionPoints(injectionTarget.getInjectionPoints());
        this.createWith(c -> {
            Object instance = injectionTarget.produce(c);
            injectionTarget.inject(instance, c);
            injectionTarget.postConstruct(instance);
            return instance;
        });
        this.destroyWith((i, c) -> {
            injectionTarget.preDestroy(i);
            c.release();
        });
        BeanAttributes<U> beanAttributes = this.beanManager.createBeanAttributes(type);
        this.read(beanAttributes);
        return (BeanConfigurator)Reflections.cast(this);
    }

    @Override
    public BeanConfigurator<T> read(BeanAttributes<?> beanAttributes) {
        this.attributes.read(beanAttributes);
        return this;
    }

    @Override
    public BeanConfigurator<T> addType(Type type) {
        this.attributes.addType(type);
        return this;
    }

    @Override
    public BeanConfigurator<T> addType(TypeLiteral<?> typeLiteral) {
        this.attributes.addType(typeLiteral.getType());
        return this;
    }

    @Override
    public BeanConfigurator<T> addTypes(Type ... types) {
        this.attributes.addTypes(types);
        return this;
    }

    @Override
    public BeanConfigurator<T> addTypes(Set<Type> types) {
        this.attributes.addTypes(types);
        return this;
    }

    @Override
    public BeanConfigurator<T> addTransitiveTypeClosure(Type type) {
        this.attributes.addTransitiveTypeClosure(type);
        return this;
    }

    @Override
    public BeanConfigurator<T> types(Type ... types) {
        this.attributes.types(types);
        return this;
    }

    @Override
    public BeanConfigurator<T> types(Set<Type> types) {
        this.attributes.types(types);
        return this;
    }

    @Override
    public BeanConfigurator<T> scope(Class<? extends Annotation> scope) {
        this.attributes.scope(scope);
        return this;
    }

    @Override
    public BeanConfigurator<T> addQualifier(Annotation qualifier) {
        this.attributes.addQualifier(qualifier);
        return this;
    }

    @Override
    public BeanConfigurator<T> addQualifiers(Annotation ... qualifiers) {
        this.attributes.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public BeanConfigurator<T> addQualifiers(Set<Annotation> qualifiers) {
        this.attributes.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public BeanConfigurator<T> qualifiers(Annotation ... qualifiers) {
        this.attributes.qualifiers(qualifiers);
        return this;
    }

    @Override
    public BeanConfigurator<T> qualifiers(Set<Annotation> qualifiers) {
        this.attributes.qualifiers(qualifiers);
        return this;
    }

    @Override
    public BeanConfigurator<T> addStereotype(Class<? extends Annotation> stereotype) {
        this.attributes.addStereotype(stereotype);
        return this;
    }

    @Override
    public BeanConfigurator<T> addStereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.attributes.addStereotypes(stereotypes);
        return this;
    }

    @Override
    public BeanConfigurator<T> stereotypes(Set<Class<? extends Annotation>> stereotypes) {
        this.attributes.stereotypes(stereotypes);
        return this;
    }

    @Override
    public BeanConfigurator<T> name(String name) {
        this.attributes.name(name);
        return this;
    }

    @Override
    public BeanConfigurator<T> alternative(boolean alternative) {
        this.attributes.alternative(alternative);
        return this;
    }

    public void initBeanManager(BeanDeploymentFinder beanDeploymentFinder) {
        if (this.beanManager == null && beanDeploymentFinder != null) {
            this.beanManager = beanDeploymentFinder.getOrCreateBeanDeployment(this.beanClass).getBeanManager();
        }
    }

    @Override
    public Bean<T> complete() {
        return new ImmutableBean(this);
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    static class ImmutableBean<T>
    extends ForwardingBeanAttributes<T>
    implements Bean<T>,
    PassivationCapable {
        private final String id;
        private final BeanManagerImpl beanManager;
        private final Class<?> beanClass;
        private final BeanAttributes<T> attributes;
        private final Set<InjectionPoint> injectionPoints;
        private final CreateCallback<T> createCallback;
        private final DestroyCallback<T> destroyCallback;

        ImmutableBean(BeanConfiguratorImpl<T> configurator) {
            this.beanManager = configurator.getBeanManager();
            this.beanClass = ((BeanConfiguratorImpl)configurator).beanClass;
            this.attributes = new BeanAttributesConfiguratorImpl(((BeanConfiguratorImpl)configurator).attributes.complete()).complete();
            this.injectionPoints = ImmutableSet.copyOf(((BeanConfiguratorImpl)configurator).injectionPoints);
            this.createCallback = ((BeanConfiguratorImpl)configurator).createCallback;
            this.destroyCallback = ((BeanConfiguratorImpl)configurator).destroyCallback;
            this.id = ((BeanConfiguratorImpl)configurator).id != null ? ((BeanConfiguratorImpl)configurator).id : BeanIdentifiers.forBuilderBean(this.attributes, this.beanClass);
        }

        @Override
        public T create(CreationalContext<T> creationalContext) {
            return this.createCallback.create(creationalContext, this.beanManager);
        }

        @Override
        public void destroy(T instance, CreationalContext<T> creationalContext) {
            if (this.destroyCallback != null) {
                this.destroyCallback.destroy(instance, creationalContext, this.beanManager);
            }
        }

        @Override
        public Class<?> getBeanClass() {
            return this.beanClass;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        protected BeanAttributes<T> attributes() {
            return this.attributes;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public String toString() {
            return "Immutable Builder Bean [" + this.getBeanClass().toString() + ", types: " + Formats.formatTypes(this.getTypes()) + ", qualifiers: " + Formats.formatAnnotations(this.getQualifiers()) + "]";
        }
    }

    static final class DestroyCallback<T> {
        private final BiConsumer<T, CreationalContext<T>> destroy;
        private final BiConsumer<T, Instance<Object>> dispose;

        static <T> DestroyCallback<T> fromDispose(BiConsumer<T, Instance<Object>> callback) {
            return new DestroyCallback<T>(callback, null);
        }

        static <T> DestroyCallback<T> fromDestroy(BiConsumer<T, CreationalContext<T>> callback) {
            return new DestroyCallback<T>(null, callback);
        }

        public DestroyCallback(BiConsumer<T, Instance<Object>> dispose, BiConsumer<T, CreationalContext<T>> destroy) {
            this.destroy = destroy;
            this.dispose = dispose;
        }

        void destroy(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.dispose != null) {
                this.dispose.accept(instance, beanManager.getInstance(ctx));
            } else {
                this.destroy.accept(instance, ctx);
            }
        }
    }

    static final class CreateCallback<T> {
        private final Supplier<T> simple;
        private final Function<CreationalContext<T>, T> create;
        private final Function<Instance<Object>, T> instance;

        static <T> CreateCallback<T> fromProduceWith(Function<Instance<Object>, T> callback) {
            return new CreateCallback<T>(null, null, callback);
        }

        static <T> CreateCallback<T> fromProduceWith(Supplier<T> callback) {
            return new CreateCallback<T>(callback, null, null);
        }

        static <T> CreateCallback<T> fromCreateWith(Function<CreationalContext<T>, T> callback) {
            return new CreateCallback<T>(null, callback, null);
        }

        public CreateCallback(Supplier<T> simple, Function<CreationalContext<T>, T> create, Function<Instance<Object>, T> instance) {
            this.simple = simple;
            this.create = create;
            this.instance = instance;
        }

        T create(CreationalContext<T> ctx, BeanManagerImpl beanManager) {
            if (this.simple != null) {
                return this.simple.get();
            }
            if (this.instance != null) {
                return this.instance.apply(beanManager.getInstance(ctx));
            }
            return this.create.apply(ctx);
        }
    }
}

